% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFMNetworksAnalyser.R
\docType{methods}
\name{AFMImageNetworksAnalysis-class}
\alias{AFMImageNetworksAnalysis-class}
\alias{AFMImageNetworksAnalysis}
\alias{initialize,AFMImageNetworksAnalysis-method}
\alias{AFMImageNetworksAnalysis}
\title{AFM image networks analysis class}
\usage{
AFMImageNetworksAnalysis()

\S4method{initialize}{AFMImageNetworksAnalysis}(.Object, vertexHashsize,
  binaryAFMImage, binaryAFMImageWithCircles, circlesTable, edgesTable,
  fusionedNodesCorrespondance, fusionedNodesEdgesTable, isolatedNodesList,
  heightNetworksslider, filterNetworkssliderMin, filterNetworkssliderMax,
  smallBranchesTreatment, originalGraph, skeletonGraph, shortestPaths,
  networksCharacteristics, holes, holesCharacteristics, graphEvcent,
  graphBetweenness, libVersion)

AFMImageNetworksAnalysis()
}
\arguments{
\item{.Object}{an AFMImageNetworksAnalysis Class}

\item{vertexHashsize}{hash to transform coordinates to vertexId}

\item{binaryAFMImage}{the AFMImage after transformation before analysis}

\item{binaryAFMImageWithCircles}{the AFMImage after transformation with the spotted circles}

\item{circlesTable}{a data.table of identified circles}

\item{edgesTable}{a data.table of edges}

\item{fusionedNodesCorrespondance}{a data.table of correspon}

\item{fusionedNodesEdgesTable}{a data.table of corresponsdance between intial node and fusioned node}

\item{isolatedNodesList}{a data.table of isolated nodes}

\item{heightNetworksslider}{used multiplier of heights to facilitate analysis}

\item{filterNetworkssliderMin}{used filter minimum value to facilitate analysis}

\item{filterNetworkssliderMax}{used filter maximum value to facilitate analysis}

\item{smallBranchesTreatment}{boolean - smallest circle used or not}

\item{originalGraph}{a list of \code{\link{igraph}}}

\item{skeletonGraph}{a list of \code{\link{igraph}}}

\item{shortestPaths}{a data.table of shortest path}

\item{networksCharacteristics}{a data.table to store the skeleton graph characteristics}

\item{holes}{a data.table to store the cluster number of each point}

\item{holesCharacteristics}{a data.table to summarize the data about holes}

\item{graphEvcent}{an array to store Evcent}

\item{graphBetweenness}{an array to store the graph betweenness}

\item{libVersion}{version of the AFM library used to perform the analysis}
}
\description{
A S4 class to handle the networks calculation

Constructor method of AFMImageNetworksAnalysis Class.

Wrapper function AFMImageNetworksAnalysis
}
\section{Slots}{

\describe{
\item{\code{vertexHashsize}}{hash to transform coordinates to vertexId}

\item{\code{binaryAFMImage}}{the AFMImage after transformation before analysis}

\item{\code{binaryAFMImageWithCircles}}{the AFMImage after transformation with the spotted circles}

\item{\code{circlesTable}}{a data.table of identified circles}

\item{\code{edgesTable}}{a data.table of edges}

\item{\code{fusionedNodesCorrespondance}}{a data.table of corresponsdance between intial node and fusioned node}

\item{\code{fusionedNodesEdgesTable}}{a data.table of nodes fusioned because of intersecting}

\item{\code{isolatedNodesTable}}{a data.table of isolated nodes}

\item{\code{heightNetworksslider}}{used multiplier of heights to facilitate analysis}

\item{\code{filterNetworkssliderMin}}{used filter minimum value to facilitate analysis}

\item{\code{filterNetworkssliderMax}}{used filter maximum value to facilitate analysis}

\item{\code{smallBranchesTreatment}}{boolean - smallest circle used or not}

\item{\code{originalGraph}}{a list of \code{\link{igraph}}}

\item{\code{skeletonGraph}}{a list of \code{\link{igraph}}}

\item{\code{shortestPaths}}{a data.table of shortest paths}

\item{\code{networksCharacteristics}}{a data.table to store the skeleton graph characteristics}

\item{\code{graphEvcent}}{an array to store Evcent}

\item{\code{graphBetweenness}}{an array to store the graph betweenness}

\item{\code{libVersion}}{version of the AFM library used to perform the analysis}

\item{\code{updateProgress}}{a function to update a graphical user interface}
}}

\author{
M.Beauvais
}
