% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{legacy_parse_IMU_C}
\alias{legacy_parse_IMU_C}
\alias{dev_parse_IMU_C}
\title{Parse all IMU packets in a file}
\usage{
legacy_parse_IMU_C(imu_records, log, info, id, samp_rate, verbose)

dev_parse_IMU_C(packets, packet_no, zero_packet, id, samp_rate, info)
}
\arguments{
\item{imu_records}{DataFrame with information about each packet}

\item{log}{RawVector containing all payload bytes}

\item{info}{The \code{sensorColumns} information of a \code{SENSOR_SCHEMA}
object}

\item{id}{integer. The \code{id} information of a \code{SENSOR_SCHEMA}
object}

\item{samp_rate}{integer. The IMU sampling rate.}

\item{verbose}{logical. Print updates to console?}

\item{packets}{list of packets}

\item{packet_no}{IntegerVector indicating which index of \code{packets} to
use for each second of expected output. Values of -1 indicate a latch to
the previous index}

\item{zero_packet}{list containing a properly-formatted packet pre-filled
with values of zero (used for USB connection events)}
}
\description{
Parse all IMU packets in a file
}
\keyword{internal}
