% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsi_analysis.R
\name{rsi}
\alias{rsi}
\title{Resistance of isolates}
\usage{
rsi(ab1, ab2 = NA, interpretation = "IR", minimum = 30, percent = FALSE,
  info = FALSE, warning = FALSE)
}
\arguments{
\item{ab1, ab2}{list with interpretations of an antibiotic}

\item{interpretation}{antimicrobial interpretation of which the portion must be calculated. Valid values are \code{"S"}, \code{"SI"}, \code{"I"}, \code{"IR"} or \code{"R"}.}

\item{minimum}{minimal amount of available isolates. Any number lower than \code{minimum} will return \code{NA} with a warning (when \code{warning = TRUE}).}

\item{percent}{return output as percent (text), will else (at default) be a double}

\item{info}{calculate the amount of available isolates and print it, like \code{n = 423}}

\item{warning}{show a warning when the available amount of isolates is below \code{minimum}}
}
\value{
Double or, when \code{percent = TRUE}, a character.
}
\description{
This function can be used in \code{dplyr}s \code{\link[dplyr]{summarise}}, see \emph{Examples}. Calculate the percentage S, SI, I, IR or R of a vector of isolates.
}
\details{
This function uses the \code{\link{rsi_df}} function internally.
}
\examples{
\dontrun{
tbl \%>\%
  group_by(hospital) \%>\%
  summarise(cipr = rsi(cipr))
  
tbl \%>\%
  group_by(year, hospital) \%>\%
  summarise(
    isolates = n(),
    cipro = rsi(cipr \%>\% as.rsi(), percent = TRUE),
    amoxi = rsi(amox \%>\% as.rsi(), percent = TRUE))
    
rsi(as.rsi(isolates$amox))

rsi(as.rsi(isolates$amcl), interpretation = "S")
}
}
\keyword{antibiotics}
\keyword{isolate}
\keyword{isolates}
\keyword{rsi}
