% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{septic_patients}
\alias{septic_patients}
\title{Dataset with 2000 blood culture isolates of septic patients}
\format{A data.frame with 2000 observations and 47 variables:
\describe{
  \item{\code{date}}{date of receipt at the laboratory}
  \item{\code{hospital_id}}{ID of the hospital}
  \item{\code{ward_icu}}{logical to determine if ward is an intensive care unit}
  \item{\code{ward_clinical}}{logical to determine if ward is a regular clinical ward}
  \item{\code{ward_outpatient}}{logical to determine if ward is an outpatient clinic}
  \item{\code{age}}{age of the patient}
  \item{\code{sex}}{sex of the patient}
  \item{\code{patient_id}}{ID of the patient, first 10 characters of an SHA hash containing irretrievable information}
  \item{\code{bactid}}{ID of microorganism, see \code{\link{bactlist}}}
  \item{\code{peni:mupi}}{38 different antibiotics with class \code{rsi} (see \code{\link{as.rsi}}), these column names occur in \code{\link{ablist}} and can be translated with \code{\link{abname}}}
}}
\source{
MOLIS (LIS of Certe) - \url{https://www.certe.nl}
}
\usage{
septic_patients
}
\description{
An anonymised dataset containing 2000 microbial blood culture isolates with their antibiogram of septic patients found in 5 different hospitals in the Netherlands, between 2001 and 2017. This data.frame can be used to practice AMR analysis e.g. with \code{\link{rsi}} or \code{\link{rsi_predict}}, or it can be used to practice other statistics.
}
\keyword{datasets}
