% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsi.R
\name{rsi}
\alias{rsi}
\title{Calculate resistance of isolates}
\usage{
rsi(ab1, ab2 = NULL, interpretation = "IR", minimum = 30,
  as_percent = FALSE, ...)
}
\arguments{
\item{ab1}{vector of antibiotic interpretations, they will be transformed internally with \code{\link{as.rsi}} if needed}

\item{ab2}{like \code{ab}, a vector of antibiotic interpretations. Use this to calculate (the lack of) co-resistance: the probability where one of two drugs have a resistant or susceptible result. See Examples.}

\item{interpretation}{antimicrobial interpretation to check for}

\item{minimum}{minimal amount of available isolates. Any number lower than \code{minimum} will return \code{NA}. The default number of \code{30} isolates is advised by the CLSI as best practice, see Source.}

\item{as_percent}{logical to indicate whether the output must be returned as percent (text), will else be a double}

\item{...}{deprecated parameters to support usage on older versions}
}
\description{
This function is deprecated. Use the \code{\link{portion}} functions instead.
}
