% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resistance_predict.R
\name{resistance_predict}
\alias{resistance_predict}
\alias{rsi_predict}
\alias{plot.resistance_predict}
\alias{ggplot_rsi_predict}
\title{Predict antimicrobial resistance}
\usage{
resistance_predict(x, col_ab, col_date = NULL, year_min = NULL,
  year_max = NULL, year_every = 1, minimum = 30,
  model = "binomial", I_as_S = TRUE, preserve_measurements = TRUE,
  info = TRUE, ...)

rsi_predict(x, col_ab, col_date = NULL, year_min = NULL,
  year_max = NULL, year_every = 1, minimum = 30,
  model = "binomial", I_as_S = TRUE, preserve_measurements = TRUE,
  info = TRUE, ...)

\method{plot}{resistance_predict}(x,
  main = paste("Resistance Prediction of", x_name), ...)

ggplot_rsi_predict(x, main = paste("Resistance Prediction of", x_name),
  ribbon = TRUE, ...)
}
\arguments{
\item{x}{a \code{data.frame} containing isolates.}

\item{col_ab}{column name of \code{x} with antimicrobial interpretations (\code{R}, \code{I} and \code{S})}

\item{col_date}{column name of the date, will be used to calculate years if this column doesn't consist of years already, defaults to the first column of with a date class}

\item{year_min}{lowest year to use in the prediction model, dafaults to the lowest year in \code{col_date}}

\item{year_max}{highest year to use in the prediction model, defaults to 10 years after today}

\item{year_every}{unit of sequence between lowest year found in the data and \code{year_max}}

\item{minimum}{minimal amount of available isolates per year to include. Years containing less observations will be estimated by the model.}

\item{model}{the statistical model of choice. Defaults to a generalised linear regression model with binomial distribution, assuming that a period of zero resistance was followed by a period of increasing resistance leading slowly to more and more resistance. See Details for valid options.}

\item{I_as_S}{a logical to indicate whether values \code{I} should be treated as \code{S}}

\item{preserve_measurements}{a logical to indicate whether predictions of years that are actually available in the data should be overwritten by the original data. The standard errors of those years will be \code{NA}.}

\item{info}{a logical to indicate whether textual analysis should be printed with the name and \code{\link{summary}} of the statistical model.}

\item{...}{parameters passed on to functions}

\item{main}{title of the plot}

\item{ribbon}{a logical to indicate whether a ribbon should be shown (default) or error bars}
}
\value{
\code{data.frame} with extra class \code{"resistance_predict"} with columns:
\itemize{
  \item{\code{year}}
  \item{\code{value}, the same as \code{estimated} when \code{preserve_measurements = FALSE}, and a combination of \code{observed} and \code{estimated} otherwise}
  \item{\code{se_min}, the lower bound of the standard error with a minimum of \code{0} (so the standard error will never go below 0\%)}
  \item{\code{se_max} the upper bound of the standard error with a maximum of \code{1} (so the standard error will never go above 100\%)}
  \item{\code{observations}, the total number of available observations in that year, i.e. S + I + R}
  \item{\code{observed}, the original observed resistant percentages}
  \item{\code{estimated}, the estimated resistant percentages, calculated by the model}
}
Furthermore, the model itself is available as an attribute: \code{attributes(x)$model}, see Examples.
}
\description{
Create a prediction model to predict antimicrobial resistance for the next years on statistical solid ground. Standard errors (SE) will be returned as columns \code{se_min} and \code{se_max}. See Examples for a real live example.
}
\details{
Valid options for the statistical model are:
\itemize{
  \item{\code{"binomial"} or \code{"binom"} or \code{"logit"}: a generalised linear regression model with binomial distribution}
  \item{\code{"loglin"} or \code{"poisson"}: a generalised log-linear regression model with poisson distribution}
  \item{\code{"lin"} or \code{"linear"}: a linear regression model}
}
}
\section{Read more on our website!}{

On our website \url{https://msberends.gitlab.io/AMR} you can find \href{https://msberends.gitlab.io/AMR/articles/AMR.html}{a tutorial} about how to conduct AMR analysis, the \href{https://msberends.gitlab.io/AMR/reference}{complete documentation of all functions} (which reads a lot easier than here in R) and \href{https://msberends.gitlab.io/AMR/articles/WHONET.html}{an example analysis using WHONET data}.
}

\examples{
x <- resistance_predict(septic_patients, col_ab = "AMX", year_min = 2010)
plot(x)
ggplot_rsi_predict(x)

# use dplyr so you can actually read it:
library(dplyr)
x <- septic_patients \%>\%
  filter_first_isolate() \%>\%
  filter(mo_genus(mo) == "Staphylococcus") \%>\%
  resistance_predict("PEN")
plot(x)


# get the model from the object
mymodel <- attributes(x)$model
summary(mymodel)


# create nice plots with ggplot2 yourself
if (!require(ggplot2)) {

  data <- septic_patients \%>\%
    filter(mo == as.mo("E. coli")) \%>\%
    resistance_predict(col_ab = "AMX",
                       col_date = "date",
                       info = FALSE,
                       minimum = 15)

  ggplot(data,
         aes(x = year)) +
    geom_col(aes(y = value),
             fill = "grey75") +
    geom_errorbar(aes(ymin = se_min,
                      ymax = se_max),
                  colour = "grey50") +
    scale_y_continuous(limits = c(0, 1),
                       breaks = seq(0, 1, 0.1),
                       labels = paste0(seq(0, 100, 10), "\%")) +
    labs(title = expression(paste("Forecast of amoxicillin resistance in ",
                                  italic("E. coli"))),
         y = "\%IR",
         x = "Year") +
    theme_minimal(base_size = 13)
}
}
\seealso{
The \code{\link{portion}} function to calculate resistance, \cr \code{\link{lm}} \code{\link{glm}}
}
