% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_microorganisms.R
\name{add_custom_microorganisms}
\alias{add_custom_microorganisms}
\alias{clear_custom_microorganisms}
\title{Add Custom Microorganisms}
\usage{
add_custom_microorganisms(x)

clear_custom_microorganisms()
}
\arguments{
\item{x}{A \link{data.frame} resembling the \link{microorganisms} data set, at least containing column "genus" (case-insensitive).}
}
\description{
With \code{\link[=add_custom_microorganisms]{add_custom_microorganisms()}} you can add your own custom microorganisms, such the non-taxonomic outcome of laboratory analysis.
}
\details{
This function will fill in missing taxonomy for you, if specific taxonomic columns are missing, see \emph{Examples}.

\strong{Important:} Due to how \R works, the \code{\link[=add_custom_microorganisms]{add_custom_microorganisms()}} function has to be run in every \R session - added microorganisms are not stored between sessions and are thus lost when \R is exited.

There are two ways to circumvent this and automate the process of adding microorganisms:

\strong{Method 1:} Using the package option \code{\link[=AMR-options]{AMR_custom_mo}}, which is the preferred method. To use this method:
\enumerate{
\item Create a data set in the structure of the \link{microorganisms} data set (containing at the very least column "genus") and save it with \code{\link[=saveRDS]{saveRDS()}} to a location of choice, e.g. \code{"~/my_custom_mo.rds"}, or any remote location.
\item Set the file location to the package option \code{\link[=AMR-options]{AMR_custom_mo}}: \code{options(AMR_custom_mo = "~/my_custom_mo.rds")}. This can even be a remote file location, such as an https URL. Since options are not saved between \R sessions, it is best to save this option to the \code{.Rprofile} file so that it will be loaded on start-up of \R. To do this, open the \code{.Rprofile} file using e.g. \code{utils::file.edit("~/.Rprofile")}, add this text and save the file:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Add custom microorganism codes:
options(AMR_custom_mo = "~/my_custom_mo.rds")
}\if{html}{\out{</div>}}

Upon package load, this file will be loaded and run through the \code{\link[=add_custom_microorganisms]{add_custom_microorganisms()}} function.
}

\strong{Method 2:} Loading the microorganism directly from your \code{.Rprofile} file. Note that the definitions will be stored in a user-specific \R file, which is a suboptimal workflow. To use this method:
\enumerate{
\item Edit the \code{.Rprofile} file using e.g. \code{utils::file.edit("~/.Rprofile")}.
\item Add a text like below and save the file:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ # Add custom antibiotic drug codes:
 AMR::add_custom_microorganisms(
   data.frame(genus = "Enterobacter",
              species = "asburiae/cloacae")
 )
}\if{html}{\out{</div>}}
}

Use \code{\link[=clear_custom_microorganisms]{clear_custom_microorganisms()}} to clear the previously added microorganisms.
}
\examples{
\donttest{
# a combination of species is not formal taxonomy, so
# this will result in "Enterobacter cloacae cloacae",
# since it resembles the input best:
mo_name("Enterobacter asburiae/cloacae")

# now add a custom entry - it will be considered by as.mo() and
# all mo_*() functions
add_custom_microorganisms(
  data.frame(
    genus = "Enterobacter",
    species = "asburiae/cloacae"
  )
)

# E. asburiae/cloacae is now a new microorganism:
mo_name("Enterobacter asburiae/cloacae")

# its code:
as.mo("Enterobacter asburiae/cloacae")

# all internal algorithms will work as well:
mo_name("Ent asburia cloacae")

# and even the taxonomy was added based on the genus!
mo_family("E. asburiae/cloacae")
mo_gramstain("Enterobacter asburiae/cloacae")

mo_info("Enterobacter asburiae/cloacae")


# the function tries to be forgiving:
add_custom_microorganisms(
  data.frame(
    GENUS = "BACTEROIDES / PARABACTEROIDES SLASHLINE",
    SPECIES = "SPECIES"
  )
)
mo_name("BACTEROIDES / PARABACTEROIDES")
mo_rank("BACTEROIDES / PARABACTEROIDES")

# taxonomy still works, even though a slashline genus was given as input:
mo_family("Bacteroides/Parabacteroides")


# for groups and complexes, set them as species or subspecies:
add_custom_microorganisms(
  data.frame(
    genus = "Citrobacter",
    species = c("freundii", "braakii complex"),
    subspecies = c("complex", "")
  )
)
mo_name(c("C. freundii complex", "C. braakii complex"))
mo_species(c("C. freundii complex", "C. braakii complex"))
mo_gramstain(c("C. freundii complex", "C. braakii complex"))
}
}
\seealso{
\code{\link[=add_custom_antimicrobials]{add_custom_antimicrobials()}} to add custom antimicrobials.
}
