% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisqtest.ANSM.R
\name{chisqtest.ANSM}
\alias{chisqtest.ANSM}
\title{Perform Chi-squared test}
\usage{
chisqtest.ANSM(
  x,
  y = NULL,
  p = NULL,
  cont.corr = TRUE,
  max.exact.cases = 10,
  nsims.mc = 1e+05,
  seed = NULL,
  do.exact = TRUE,
  do.asymp = FALSE,
  do.mc = FALSE
)
}
\arguments{
\item{x}{Factor of same length as y, or table}

\item{y}{Factor of same length as x (or NULL if x is table) (defaults to \code{NULL})}

\item{p}{Vector of probabilities (expressed as numbers between 0 and 1 and summing to 1) of same length as x or NULL (defaults to \code{NULL})}

\item{cont.corr}{Boolean indicating whether or not to use continuity correction (defaults to \code{TRUE})}

\item{max.exact.cases}{Maximum number of cases allowed for exact calculations (defaults to \code{10})}

\item{nsims.mc}{Number of Monte Carlo simulations to be performed (defaults to \code{100000})}

\item{seed}{Random number seed to be used for Monte Carlo simulations (defaults to \code{NULL})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.mc}{Boolean indicating whether or not to perform Monte Carlo calculations (defaults to \code{FALSE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{chisqtest.ANSM()} is a wrapper for chisq.test() from the \code{stats} package - performs the Chi-squared test and is used in chapters 12 and 13 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 12.1 from "Applied Nonparametric Statistical Methods" (5th edition)
chisqtest.ANSM(ch12$feedback.freq, ch12$PPI.person, do.exact = FALSE, do.asymp = TRUE)

# Exercise 13.7 from "Applied Nonparametric Statistical Methods" (5th edition)
chisqtest.ANSM(ch13$medicine[ch13$location == "Rural"],
  ch13$response[ch13$location == "Rural"], seed = 1)

}
