% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohen.kappa.R
\name{cohen.kappa}
\alias{cohen.kappa}
\title{Calculate Cohen's kappa}
\usage{
cohen.kappa(
  y1,
  y2,
  blocks = NULL,
  alternative = c("two.sided", "less", "greater"),
  CI.width = 0.95,
  max.exact.cases = 10,
  nsims.mc = 1e+05,
  seed = NULL,
  do.asymp = FALSE,
  do.exact = TRUE,
  do.CI = FALSE,
  do.mc = FALSE
)
}
\arguments{
\item{y1}{Factor of same length as y2, blocks and same levels as y2 and (if blocks not NULL) with 2 levels}

\item{y2}{Factor of same length as y1, blocks and same levels as y1 and (if blocks not NULL) with 2 levels}

\item{blocks}{Factor of same length as y1, y2 or NULL (defaults to \code{NULL})}

\item{alternative}{Type of alternative hypothesis (defaults to \code{two.sided})}

\item{CI.width}{Confidence interval width (defaults to \code{0.95})}

\item{max.exact.cases}{Maximum number of cases allowed for exact calculations (defaults to \code{10})}

\item{nsims.mc}{Number of Monte Carlo simulations to be performed (defaults to \code{100000})}

\item{seed}{Random number seed to be used for Monte Carlo simulations (defaults to \code{NULL})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}

\item{do.CI}{Boolean indicating whether or not to perform confidence interval calculations (defaults to \code{FALSE})}

\item{do.mc}{Boolean indicating whether or not to perform Monte Carlo calculations (defaults to \code{FALSE})}
}
\value{
An ANSMstat object with the results from applying the function
}
\description{
\code{cohen.kappa()} calculates Cohen's kappa and is used in chapter 10 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 10.11 from "Applied Nonparametric Statistical Methods" (5th edition)
cohen.kappa(ch10$dentistA, ch10$dentistB, do.asymp = TRUE, do.exact = FALSE,
  alternative = "greater")

# Example 10.12 from "Applied Nonparametric Statistical Methods" (5th edition)
cohen.kappa(ch10$questionnaire, ch10$demonstration, ch10$items)

}
