% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/friedman.lsd.R
\name{friedman.lsd}
\alias{friedman.lsd}
\title{Perform Least Significant Differences test after the Friedman test}
\usage{
friedman.lsd(y, groups, blocks, ids)
}
\arguments{
\item{y}{Numeric vector of same length as groups, blocks}

\item{groups}{Factor of same length as y, blocks with levels such that length(y) == nlevels(groups) * nlevels(blocks)}

\item{blocks}{Factor of same length as y, groups with levels such that length(y) == nlevels(groups) * nlevels(blocks)}

\item{ids}{Vector of length 2 with elements both levels of groups}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{friedman.lsd()} performs the Least Significant Differences test after the Friedman test and is used in chapter 8 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 8.11 from "Applied Nonparametric Statistical Methods" (5th edition)
friedman.lsd(ch8$prey.preference, ch8$prey, ch8$larva, c("Cyclops", "Anopheles"))

#  from "Applied Nonparametric Statistical Methods" (5th edition)

}
