% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/friedman.R
\name{friedman}
\alias{friedman}
\title{Perform Friedman test}
\usage{
friedman(
  y,
  groups,
  blocks,
  use.Iman.Davenport = FALSE,
  max.exact.perms = 1e+05,
  nsims.mc = 1e+05,
  seed = NULL,
  do.asymp = FALSE,
  do.exact = TRUE
)
}
\arguments{
\item{y}{Numeric vector of same length as groups, blocks}

\item{groups}{Factor of same length as y, blocks with levels such that length(y) == nlevels(groups) * nlevels(blocks)}

\item{blocks}{Factor of same length as y, groups with levels such that length(y) == nlevels(groups) * nlevels(blocks)}

\item{use.Iman.Davenport}{Boolean indicating whether or not to use Iman and Davenport approximation (defaults to \code{FALSE})}

\item{max.exact.perms}{Maximum number of permutations allowed for exact calculations (defaults to \code{100000})}

\item{nsims.mc}{Number of Monte Carlo simulations to be performed (defaults to \code{100000})}

\item{seed}{Random number seed to be used for Monte Carlo simulations (defaults to \code{NULL})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{friedman()} performs the Friedman test and is used in chapter 7 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 7.6 from "Applied Nonparametric Statistical Methods" (5th edition)
friedman(ch7$pulse, ch7$time.period, ch7$student, do.exact = FALSE, do.asymp = TRUE)

# Exercise 7.12 from "Applied Nonparametric Statistical Methods" (5th edition)
friedman(ch7$names.recalled, ch7$group, ch7$medical.student, use.Iman.Davenport = TRUE,
  do.exact = FALSE, do.asymp = TRUE)

}
