% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.geodesicDiameter.single.R
\name{met.geodesicDiameter.single}
\alias{met.geodesicDiameter.single}
\title{Geodesic distances and diameter}
\usage{
met.geodesicDiameter.single(
  m,
  weighted = TRUE,
  shortest.weight = FALSE,
  normalization = TRUE,
  directed = TRUE,
  out = TRUE
)
}
\arguments{
\item{m}{a square adjacency matrix.}

\item{weighted}{if \emph{FALSE}, it binarizes the square adjacency matrix M. Geodesic distances and diameter are based only on the presence or absence of edges.}

\item{shortest.weight}{if \emph{false}, it considers the higher met.strength as the shortest path.}

\item{normalization}{normalizes the weigths of the links i.e. divides them by the average strength of the network. Argument normalization can't be TRUE when  argument weighted is FALSE.}

\item{directed}{if \emph{false}, then it symmetrizes the matrix. Otherwise, it calculates geodesic distances and diameter according to the directionality of the links.}

\item{out}{if \emph{true}, it considers}
}
\value{
A list of two elements:
\itemize{
\item The first element is the diameter of the network according to the option specified (weigthed or not, directed or not, throught shortest weights or stronger weights)
\item The second element is the geodesic distances between all nodes according to the option specified (weigthed or not, directed or not, throught shortest weights or stronger weights)
}
}
\description{
Calculates 1) Geodesic Distances and 2) network diameter .
}
\details{
Binary network met.density is the ratio of existing links of a network in relation to all potential links.
}
\references{
Sosa, S. (2018). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
\keyword{internal}
