% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.disparity.single.R
\name{met.disparity.single}
\alias{met.disparity.single}
\title{Disparity}
\usage{
met.disparity.single(M, df = NULL, dfid = NULL)
}
\arguments{
\item{M}{a square adjacency matrix.}

\item{df}{a data frame of same length of the input matrix.}

\item{dfid}{an integer indicating the column of individual ids in argument \emph{df}}

\item{directed}{if \emph{true}  then calculate the met.disparity directed version \emph{i.e.} in-met.disparity, out-met.disparity, met.disparity.}
}
\value{
\itemize{
\item For the undirected version: Return an integer vector of each vertices met.disparity.
\item For the undirected version: Return a data frame of three columns: met.disparity,inDisparity,outDisparity.
}
}
\description{
Calculate for all the vertices the node metric call met.disparity.
}
\details{
Disparity measures the weight variation of a node. This metric compares a node's strength with its degree. It provides information on the type of edges found in a node \emph{i}, \emph{i.e.} few strong edges or many weak edges
met.disparity of a vertice \emph{i} is the summe of the squares of the division between the weigthed edge between node \emph{i} and \emph{j} and the met.strength of node \emph{i}
}
\references{
Whitehead, H. A. L. (1997). Analysing animal social structure. Animal behaviour, 53(5), 1053-1067.

Sosa, S. (2018). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
\keyword{internal}
