% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strip_names.R
\name{strip_names}
\alias{strip_names}
\title{Strip taxonomic names of subtaxa designations and special characters}
\usage{
strip_names(taxon_names)
}
\arguments{
\item{taxon_names}{A character vector of taxonomic names to be stripped.}
}
\value{
A character vector of stripped taxonomic names, with subtaxa designations, special
characters, and extra whitespace removed, and all letters converted to lowercase.
}
\description{
Given a vector of taxonomic names, this function removes subtaxa designations ("subsp.", "var.", "f.", and "ser"),
special characters (e.g., "-", ".", "(", ")", "?"), and extra whitespace. The resulting vector
of names is also converted to lowercase.
}
\examples{
strip_names(c("Abies lasiocarpa subsp. lasiocarpa",
              "Quercus kelloggii",
              "Pinus contorta var. latifolia"))

}
