% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_clone_sizes.R
\name{mergeCloneSizes}
\alias{mergeCloneSizes}
\title{Merge a list of Clustered Clonotype Frequency Tables}
\usage{
mergeCloneSizes(clustered_clone_sizes, sort_decreasing = TRUE)
}
\arguments{
\item{clustered_clone_sizes}{the output of \link{countCloneSizes}.}

\item{sort_decreasing}{a logical or NULL. If \code{TRUE}/\code{FALSE}, sorts the
table by clonotype frequency with largest/smallest clones first, and if
NULL, no order is guaranteed but the output is deterministic.}
}
\value{
a table object
}
\description{
The list of clustered clonotype frequencies from \link{countCloneSizes}
can be merged by this function to a frequency table of all clonotypes
similar to the data that can be seen in the seurat object metadata.
By default, this function sorts the table with largest clonotypes first,
and this may be useful for quickly gauging which clonotypes are the most
expanded overall.
}
\examples{
clustered_clone_sizes <- countCloneSizes(get(data("combined_pbmc")))
mergeCloneSizes(clustered_clone_sizes)

}
\seealso{
\link{countCloneSizes}
}
