% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/effect_size_estimators.R
\name{PIR_MOM}
\alias{PIR_MOM}
\title{Moment estimator for prevalence and incidence, with bootstrap confidence intervals}
\usage{
PIR_MOM(PIR, phase, base_level, intervals, interval_length, rest_length = 0,
  Bootstraps = 2000, conf_level = 0.95, exponentiate = FALSE,
  seed = NULL)
}
\arguments{
\item{PIR}{vector of PIR measurements}

\item{phase}{factor or vector indicating levels of the PIR measurements.}

\item{base_level}{a character string or value indicating the name of the baseline level.}

\item{intervals}{the number of intervals in the sample of observations}

\item{interval_length}{the total length of each interval}

\item{rest_length}{length of the portion of the interval devoted to recording. Default is \code{0}}

\item{Bootstraps}{desired number of bootstrap replicates. Default is \code{2000}}

\item{conf_level}{Desired coverage rate of the calculated confidence interval. Default is \code{.95}.}

\item{exponentiate}{a logical indicating whether the row corresponding to the ratio of treatment to baseline should be exponentiated, with the default as \code{FALSE}.}

\item{seed}{seed value set in order to make bootstrap results reproducible. Default is \code{null}}
}
\value{
A dataframe with six columns and three rows corresponding to baseline, treatment,
and the log ratio or ratio (depending upon the value of \code{exponentiate}) of treatment to baseline
}
\description{
Estimates prevalance and incidence for two samples,
along with the ratios of each parameter, assuming that the behavior follows
an `. Also provides boostrap confidence intervals.
}
\details{
The moment estimators are based on the assumption that the
underlying behavior stream follows an Alternating Poisson Process, in which both the
event durations and interim times are exponentially distributed.
}
\examples{
# Estimate prevalence and incidence ratios for Carl from the Moes dataset
data(Moes)
with(subset(Moes, Case == "Carl"),
PIR_MOM(PIR = outcome, phase = Phase, intervals = intervals,
interval_length = (active_length + rest_length), rest_length = rest_length,
base_level = "No Choice", seed = 149568373))
}
\author{
Daniel Swan <dswan@utexas.edu>
}

