#' AcousticNDLCodeR-Package 
#'
#
#' @author Denis Arnold
#' @docType package
#' @name AcousticNDLCodeR
#' @description Package to make acoustic cues to use with ndl or ndl2. 
#' @details 
#'          The packages main function is \code{\link{makeCues}}. \code{\link{readTextGridFast}}, 
#'          \code{\link{readTextGridRobust}}, \code{\link{readESPSAnnotation}} and 
#'          \code{\link{readWavesurfer}} are helper functions that read the corresponding annotation
#'          files and return a data.frame. \code{\link{CorpusCoder}} codes a whole corpus given a vector
#'          with the path to and names of wave files and a vector for the annotation files. 
#'          \code{\link{word_classification_data}} provides data from Arnold et al 2017 
#'          https://doi.org/10.1371/journal.pone.0174623
#'
#' @references  Reference to to paper in accepted form.
#' @examples 
#'            \dontrun{
#'            # assuming the corpus contains wave files and praat textgrids
#'            
#'            setwd(~/Data/MyCorpus) # assuming everything is in one place
#'            
#'            #assuming you have one wav for each annotation
#'            
#'            Waves=list.files(pattern="*.wav",recursive=T)
#'            Annotations=list.files(pattern="*.TextGrids",recursive=T) # see above
#'            
#'            # Lets assume the annotation is in UTF-8 and you want everything from a tier called words
#'            # Lets assume tha you want to dismiss everything in <|>
#'            # Lets assume that have 4 cores available
#'            # Lets assume that you want the defaut settings for the parameters
#'            
#'            Data=CorpusCoderCorpusCoder(Waves, Annotations, AnnotationType = "TextGrid",
#'            TierName = "words", Dismiss = "<|>", Encoding, Fast = F, Cores = 4, 
#'            IntensitySteps = 5, Smooth = 800)
#'            
#'            }
"_PACKAGE"