% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fat2_table.R
\name{fat2_table}
\alias{fat2_table}
\title{Utils: Summary of the analysis for factor arrangement with two qualitative factors.}
\usage{
fat2_table(output, nf1, nf2, column = 1)
}
\arguments{
\item{output}{Output of summarise_anova function for FAT2DIC, FAT2DIC.ad, FAT2DBC, FAT2DBC.ad, PSUBDIC and PSUBDBC design.}

\item{nf1}{Number of levels of factor 1}

\item{nf2}{Number of levels of factor 2}

\item{column}{Variable column}
}
\value{
returns a list containing analysis output for experiments in FAT2DIC, FAT2DIC.ad, FAT2DBC, FAT2DBC.ad, PSUBDIC and PSUBDBC design.
}
\description{
Summarizes the output returned in the summarise_anova function in list form. The advantage is that the table, in the case of significant interaction, is returned in a format that facilitates assembly in terms of scientific publication.
}
\examples{

#==============================================================
data(corn)
attach(corn)
a=FAT2DIC(A, B, Resp, quali=c(TRUE, TRUE))
output_1=summarise_anova(list(a),design="FAT2DIC",divisor = FALSE)
fat2_table(output_1,nf1=3,nf2=2,column=1)

#==============================================================
data(cloro)
respAd=c(268, 322, 275, 350, 320)
resu=with(cloro, FAT2DIC.ad(f1, f2, bloco, resp, respAd))
output_2=summarise_anova(list(resu),design="FAT2DIC.ad",divisor = FALSE)
fat2_table(output_2,nf1=2,nf2=4,column=1)
}
\author{
Gabriel Danilo Shimizu
}
