% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LNplt_analysis.R
\name{linear.plateau}
\alias{linear.plateau}
\title{Analysis: Linear-Plateau Regression}
\usage{
linear.plateau(
  trat,
  resp,
  ylab = "Dependent",
  xlab = "Independent",
  theme = theme_classic(),
  legend.position = "top",
  error = "SE",
  r2 = "all",
  point = "all",
  width.bar = NA,
  scale = "none",
  textsize = 12,
  pointsize = 4.5,
  linesize = 0.8,
  pointshape = 21,
  comment = NA
)
}
\arguments{
\item{trat}{Numeric vector with dependent variable.}

\item{resp}{Numeric vector with independent variable.}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_bw())}

\item{legend.position}{legend position (\emph{default} is "top")}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{r2}{coefficient of determination of the mean or all values (\emph{default} is all)}

\item{point}{defines whether you want to plot all points ("all") or only the mean ("mean")}

\item{width.bar}{Bar width}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}

\item{textsize}{Font size}

\item{pointsize}{shape size}

\item{linesize}{line size}

\item{pointshape}{format point (default is 21)}

\item{comment}{Add text after equation}
}
\value{
The function returns a list containing the coefficients and their respective values of p; statistical parameters such as AIC, BIC, pseudo-R2, RMSE (root mean square error); breakpoint and the graph using ggplot2 with the equation automatically.
}
\description{
This function performs the quadratic-plateau regression analysis.
}
\details{
The linear-plateau model is defined by:
First curve:
\deqn{f(x) = \beta_0 + \beta_1 \times x (x < breakpoint)}

Second curve:
\deqn{f(x) = \beta_0 + \beta_1 \times breakpoint (x > breakpoint)}
}
\examples{
library(AgroReg)
data("granada")
attach(granada)
linear.plateau(time,WL)
}
\references{
Chiu, G. S., R. Lockhart, and R. Routledge. 2006. Bent-cable regression theory and applications. Journal of the American Statistical Association 101:542-553.

Toms, J. D., and M. L. Lesperance. 2003. Piecewise regression: a tool for identifying ecological thresholds. Ecology 84:2034-2041.
}
\seealso{
\link{quadratic.plateau}, \link{linear.linear}
}
\author{
Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
