% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pas_load.R
\name{pas_load}
\alias{pas_load}
\title{Load PurpleAir synoptic data}
\usage{
pas_load(
  datestamp = NULL,
  retries = 30,
  timezone = "America/Los_Angeles",
  archival = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{datestamp}{Local date string in valid YYYY-mm-dd format. See description.}

\item{retries}{Max number of days to go back and try to load if requested 
date cannot be retrieved.}

\item{timezone}{Timezone used to interpret \code{datestamp}.}

\item{archival}{Logical specifying whether a version should be loaded that
includes sensors that have stopped reporting.}

\item{verbose}{Logical controlling the generation of warning and error messages.}
}
\value{
A PurpleAir Synoptic \emph{pas} object.
}
\description{
A pre-generated \emph{pa_synoptic} object will be loaded for
  the given date. These files are generated each day and provide
  a record of all currently installed PurpleAir sensors for the day of 
  interest. With default arguments, this function will always load data 
  associated with the most recent pre-generated file -- typically less than 
  one hour old.

  The \code{datestamp} can be anything that is understood by 
  \code{lubrdiate::ymd()} including either of the following recommended 
  formats:

\itemize{
\item{\code{"YYYYmmdd"}}
\item{\code{"YYYY-mm-dd"}}
}

By default, the host computer's date is used.

The \emph{pas} object for a specific hour may be loaded by specifying 
\code{datestamp = "YYYYmmddHH"}.
}
\examples{
\donttest{
library(AirSensor)

setArchiveBaseUrl("http://data.mazamascience.com/PurpleAir/v1")

pas <- pas_load()

if ( interactive() ) {
  pas \%>\% 
    pas_filter(stateCode == "CA") \%>\%
    pas_leaflet()
}
} 
}
\seealso{
\link{pas_createNew}
}
