% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AlphaPart.R
\name{AlphaPart}
\alias{AlphaPart}
\title{AlphaPart.R}
\usage{
AlphaPart(x, pathNA = FALSE, recode = TRUE, unknown = NA,
  sort = TRUE, verbose = 1, profile = FALSE, printProfile = "end",
  pedType = "IPP", colId = 1, colFid = 2, colMid = 3,
  colPath = 4, colAGV = 5:ncol(x), colBy = NULL)
}
\arguments{
\item{x}{data.frame , with (at least) the following columns: individual, father, and mother identif ication,
and year of birth; see arguments \code{colId},
\code{colFid}, \code{colMid}, \code{colPath}, and \code{colAgv}; see also details about the validity of pedigree.}

\item{pathNA}{Logical, set dummy path (to "XXX") where path information is unknown (missing).}

\item{recode}{Logical, internally recode individual, father and, mother identif ication to
\code{1:n} codes, while missing parents are defined with \code{0}; this option
must be used if  identif ications in \code{x} are not already given as \code{1:n}
codes, see also argument \code{sort}.}

\item{unknown}{Value(s) used for representing unknown (missing) parent in \code{x}; this options
has an effect only when \code{recode=FALSE} as it is only needed in that situation.}

\item{sort}{Logical, initially sort \code{x} using \code{orderPed()} so that children follow
parents in order to make imputation as optimal as possible (imputation is performed
within a loop from the first to the last unknown birth year); at the end original
order is restored.}

\item{verbose}{Numeric, print additional information: \code{0} - print nothing, \code{1} - print
some summaries about the data.}

\item{profile}{Logical, collect timings and size of objects.}

\item{printProfile}{Character, print profile info on the fly (\code{"fly"}) or at the end (\code{"end"}).}

\item{pedType}{Character, pedigree type: the most common form is \code{"IPP"} for Individual, Parent
1 (say father), and Parent 2 (say mother) data; the second form is \code{"IPG"} for
Individual, Parent 1 (say father), and one of Grandparents of Parent 2 (say maternal
grandfather).}

\item{colId}{Numeric or character, position or name of a column holding individual identif ication.}

\item{colFid}{Numeric or character, position or name of a column holding father identif ication.}

\item{colMid}{Numeric or character, position or name of a column holding mother identif ication or
maternal grandparent identif ication if  \code{pedType="IPG"} .}

\item{colPath}{Numeric or character, position or name of a column holding path information.}

\item{colAGV}{Numeric or character, position(s) or name(s) of column(s) holding Additive Genetic Values.}

\item{colBy}{Numeric or character, position or name of a column holding group information (see details).}
}
\value{
An object of class \code{AlphaPart}, which can be used in further analyses - there is a handy summary
method (\code{\link[AlphaPart]{summary.AlphaPart}} works on objects of \code{AlphaPart} class) and a plot method
for its output (\code{\link[AlphaPart]{plot.summaryAlphaPart}} works on objects of \code{summaryAlphaPart} class).
Class \code{AlphaPart} is a list. The first \code{length(colAGV)} components (one for each trait and named with
trait label, say trt) are data frames. Each data.frame contains:
  \item{\code{x}}{columns from initial data \code{x}}
  \item{trt_pa}{parent average}
  \item{trt_w}{Mendelian sampling term}
  \item{trt_path1, trt_path2, ...}{additive genetic value partitions}

The last component of returned object is also a list named \code{info} with the following components holding
meta information about the analysis:
  \item{path}{column name holding path information}
  \item{nP}{number of paths}
  \item{lP}{path labels}
  \item{nT}{number of traits}
  \item{lT}{trait labels}
  \item{warn}{potential warning messages associated with this object}

If  \code{colBy!=NULL} the resulting object is of a class \code{summaryAlphaPart},
see \code{\link[AlphaPart]{summary.AlphaPart}} for details.

If  \code{profile=TRUE}, profiling info is printed on screen to spot any computational bottlenecks.
}
\description{
A function to partition additive genetic values by paths. The partition method is
described in García-Cortés et al., 2008: Partition of the genetic trend to validate multiple selection decisions.
Animal : an international journal of animal bioscience. DOI: 10.1017/S175173110800205X
}
\details{
Pedigree in \code{x} must be valid in a sense that there are:\itemize{
\item{no directed loops (the simplest example is that the individual identif ication is equal to the identif ication of a father or mother)}
\item{no bisexuality, e.g., fathers most not appear as mothers}
\item{father and/or mother can be unknown (missing) - defined with any "code" that is dif ferent from existing identif ications}
}

Unknown (missing) values for additive genetic values are propagated down the pedigree
to provide all available values from genetic evaluation. Another option is
to cut pedigree links - set parents to unknown and remove them from pedigree
prior to using this function - see \code{\link[AlphaPart]{pedSetBase}} function.
Warning is issued in the case of unknown (missing) values.

In animal breeding/genetics literature the model with the underlying pedigree type
\code{"IPP"} is often called animal model, while the model for pedigree type \code{"IPG"}
is often called sire - maternal grandsire model. With a combination of \code{colFid}
and \code{colMid} mother - paternal grandsire model can be accomodated as well.

Argument \code{colBy} can be used to directly perform a summary analysis by
group, i.e., \code{summary(AlphaPart(...), by="group")}. See \code{\link[AlphaPart]{summary.AlphaPart}}
for more. This can save some CPU time by skipping intermediate steps. However,
only means can be obtained, while \code{summary} method gives more flexibility.
}
\examples{
## Small pedigree with additive genetic (=breeding) values
ped <- data.frame(  id=c(  1,   2,   3,   4,   5,   6),
                   fid=c(  0,   0,   2,   0,   4,   0),
                   mid=c(  0,   0,   1,   0,   3,   3),
                   loc=c("A", "B", "A", "B", "A", "A"),
                   gen=c(  1,   1,   2,   2,   3,   3),
                  trt1=c(100, 120, 115, 130, 125, 125),
                  trt2=c(100, 110, 105, 100,  85, 110))

## Partition additive genetic values
tmp <- AlphaPart(x=ped, colAGV=c("trt1", "trt2"))
print(tmp)

## Summarize by generation
summary(tmp, by="gen")

\donttest{
## There are also two demos
demo(topic="AlphaPart_deterministic", package="AlphaPart", ask=interactive())
demo(topic="AlphaPart_stochastic",     package="AlphaPart", ask=interactive())
}
}
\references{
Garcia-Cortes, L. A. et al. (2008) Partition of the genetic trend to validate multiple selection
decisions. Animal, 2(6):821-824. \url{http://dx.doi.org/10.1017/S175173110800205X}
}
\seealso{
\code{\link[AlphaPart]{summary.AlphaPart}} for summary method that works on output of \code{AlphaPart},
\code{\link[AlphaPart]{pedSetBase}} for setting base population,
\code{\link[AlphaPart]{pedFixBirthYear}} for imputing unknown (missing) birth years,
\code{\link[pedigree]{orderPed}} in \pkg{pedigree} package for sorting pedigree
}
