% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SimParam.R
\name{SimParam_setTrackRec}
\alias{SimParam_setTrackRec}
\title{Set recombination tracking}
\arguments{
\item{isTrackRec}{should recombination tracking be on.}

\item{force}{should the check for a running simulation be 
ignored. Only set to TRUE if you know what you are doing.}
}
\description{
Sets recombination tracking for the simulation. 
By default recombination tracking is turned off. When turned 
on recombination tracking will also turn on pedigree tracking. 
Recombination tracking keeps records of all individuals created, 
except those created by \code{\link{hybridCross}}, because their 
pedigree is not tracked.
}
\section{Usage}{
 SimParam$setTrackRec(isTrackRec, force = FALSE)
}

\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$setTrackRec(TRUE)

}
