% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hardwareSprites.r, R/iff.0.r
\docType{methods}
\name{as.raw}
\alias{as.raw}
\alias{as.raw,hardwareSprite-method}
\alias{as.raw}
\alias{as.raw,IFFChunk-method}
\alias{as.raw.IFF.ANY}
\title{Convert AmigaFFH objects into raw data}
\usage{
\S4method{as.raw}{hardwareSprite}(x)

\S4method{as.raw}{IFFChunk}(x)

\method{as.raw}{IFF.ANY}(x, ...)
}
\arguments{
\item{x}{An AmigaFFH object that needs to be converted into raw data.
See usage section for all supported objects.}

\item{...}{Arguments passed on to \code{\link{IFFChunk-method}} when \code{x} is
of class \code{IFF.ANY}.}
}
\value{
Returns a \code{vector} of \code{raw} data based on \code{x}.
}
\description{
Convert AmigaFFH objects into raw data, as they would be stored in the Commodore
Amiga's memory or files.
}
\details{
Objects originating from this package can in some cases be converted into
raw data, as they would be stored on an original Amiga. See the usage section
for the currently supported objects.
As this package grows additional objects can be converted with this method.
}
\examples{
\dontrun{
## read an IFF file as an IFFChunk object:
example.iff <- read.iff(system.file("ilbm8lores.iff", package = "AmigaFFH"))

## This will recreate the exact raw data as it was read from the file:
example.raw <- as.raw(example.iff)
}
}
\seealso{
Other iff.operations: \code{\link{IFFChunk-class}},
  \code{\link{WaveToIFF}}, \code{\link{as.raster}},
  \code{\link{getIFFChunk}},
  \code{\link{interpretIFFChunk}},
  \code{\link{rasterToIFF}}, \code{\link{read.iff}},
  \code{\link{write.iff}}

Other raw.operations: \code{\link{colourToAmigaRaw}},
  \code{\link{packBitmap}}, \code{\link{rawToHWSprite}}
}
\author{
Pepijn de Vries
}
