% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.r
\name{read.AmigaBasicBMAP}
\alias{read.AmigaBasicBMAP}
\alias{write.AmigaBasicBMAP}
\title{Read and write Amiga Basic BMAP files}
\usage{
read.AmigaBasicBMAP(file, disk = NULL)

write.AmigaBasicBMAP(x, file, disk = NULL)
}
\arguments{
\item{file}{A \code{character} string of the filename of the Amiga Basic BMAP file to be read or written.}

\item{disk}{A virtual Commodore Amiga disk from which the \code{file} should be
read or written to. This should be an \code{\link[adfExplorer:amigaDisk-class]{amigaDisk()}} object. Using
this argument requires the adfExplorer package.
When set to \code{NULL}, this argument is ignored.}

\item{x}{A \code{\link[=AmigaBasicBMAP]{AmigaBasicBMAP()}} class object that needs to be
stored.}
}
\value{
Returns an \code{\link[=AmigaBasicBMAP]{AmigaBasicBMAP()}} class object read from the \code{file} in case of
\code{read.AmigaBasicBMAP}. Otherwise, invisibly returns the result of the call of \code{close} to the
file connection. Or, when \code{disk} is specified, a copy of
\code{disk} is returned to which the file is written.
}
\description{
Read and write \code{\link[=AmigaBasicBMAP]{AmigaBasicBMAP()}} binary file format.
}
\details{
An \link[=AmigaBasicBMAP]{Amiga Basic BMAP} file maps the offset of routines in Amiga libraries and can be
read as a comprehensive list and written back to a binary file using these functions.
}
\examples{
\dontrun{
## A small fragment of the dos.library BMAP would look like this:
dos.bmap <- as.AmigaBasicBMAP(list(
  xOpen = list(
    libraryVectorOffset = -30,
    registers = as.raw(2:3)
  ),
  xClose = list(
    libraryVectorOffset = -36,
    registers = as.raw(2)
  ),
  xRead = list(
    libraryVectorOffset = -42,
    registers = as.raw(2:4)
  )
))

## This will write the BMAP to a file:
write.AmigaBasicBMAP(dos.bmap, file.path(tempdir(), "dos.bmap"))

## This will read the same file:
dos.bmap.copy <- read.AmigaBasicBMAP(file.path(tempdir(), "dos.bmap"))
}
}
\seealso{
Other AmigaBasic.operations: 
\code{\link{AmigaBasic.reserved}()},
\code{\link{AmigaBasicBMAP}},
\code{\link{AmigaBasic}},
\code{\link{[.AmigaBasic}()},
\code{\link{as.AmigaBasicBMAP}()},
\code{\link{as.AmigaBasic}()},
\code{\link{as.character}()},
\code{\link{check.names.AmigaBasic}()},
\code{\link{names.AmigaBasic}()},
\code{\link{rawToAmigaBasicBMAP}()},
\code{\link{rawToAmigaBasic}()},
\code{\link{read.AmigaBasic}()},
\code{\link{write.AmigaBasic}()}

Other io.operations: 
\code{\link{read.AmigaBasicShape}()},
\code{\link{read.AmigaBasic}()},
\code{\link{read.AmigaBitmapFontSet}()},
\code{\link{read.AmigaBitmapFont}()},
\code{\link{read.AmigaIcon}()},
\code{\link{read.SysConfig}()},
\code{\link{read.iff}()},
\code{\link{write.AmigaBasicShape}()},
\code{\link{write.AmigaBasic}()},
\code{\link{write.AmigaBitmapFont}()},
\code{\link{write.AmigaIcon}()},
\code{\link{write.SysConfig}()},
\code{\link{write.iff}()}
}
\author{
Pepijn de Vries
}
\concept{AmigaBasic.operations}
\concept{io.operations}
