% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AntManAPI.R
\name{AM_mcmc_fit}
\alias{AM_mcmc_fit}
\title{Performs a Gibbs sampling}
\usage{
AM_mcmc_fit(y, mix_kernel_hyperparams, initial_clustering = NULL,
  init_K = NULL, fixed_clustering = NULL,
  mix_components_prior = AM_mix_components_prior_pois(),
  mix_weight_prior = AM_mix_weights_prior_gamma(),
  mcmc_parameters = AM_mcmc_parameters())
}
\arguments{
\item{y}{input data, can be a vector or a matrix.}

\item{mix_kernel_hyperparams}{is a configuration list, defined by *_mix_hyperparams functions, where * denotes the chosen kernel.}

\item{initial_clustering}{is a vector CI of initial cluster assignement. If no clustering is specified (either as \code{init_K} or \code{init_clustering}), then every observation is assigned to its own cluster.}

\item{init_K}{initial value for  the number of cluster. When this is specified, AntMAN intitialises the clustering assign usng K-means.}

\item{fixed_clustering}{is a vector CI of cluster assignement that will remained unchanged for every iterations.}

\item{mix_components_prior}{is a configuration list defined by AM_mix_components_prior_* functions, where * denotes the chosen prior.}

\item{mix_weight_prior}{is a configuration list defined by AM_weight_prior_* functions, where * denotes the chosen prior specification.}

\item{mcmc_parameters}{is a configuration list defined by AM_mcmc_parameters.}
}
\value{
The return value is a \code{\link{AM_mcmc_output}} object.
}
\description{
The \code{AM_mcmc_fit} function performs a Gibbs sampling in order to estimate
a mixture of a predifined type \code{mix_kernel_hyperparams} (defined with \code{AM_*_mix_hyperparams} functions, where star
\code{*} denotes the chosen kernel)
sample data \code{y}.
Additionaly a prior distribution on the number of mixture components
must be specified  through  \code{mix_components_prior}
(generated with  \code{AM_mix_components_prior_*} functions, where \code{*}  denotes the chosen prior). Similarly,
a prior on the weights of  the mixture is specified through \code{mix_weight_prior}
(defined with  \code{AM_mix_weights_prior_*} functions). Finally, with \code{mcmc_parameters} the user sets
the MCMC parameters for the Gibbs sampler (defined with  \code{AM_mcmc_parameters} functions).
}
\details{
If no initial clustering is specified (either as \code{init_K} or \code{init_clustering}),
then every observation is allocated to a different cluster.
If \code{init_K} is specified then AntMAN initialises the clustering through K-means.

\strong{Warning}: if the user does not specify init_K or initial_cluster, the first steps can be be time-consuming because of default value for the initial clustering.
}
\examples{
AM_mcmc_fit( AM_sample_unipois()$y, 
             AM_unipois_mix_hyperparams (alpha0=2, beta0=0.2), 
             mcmc_parameters = AM_mcmc_parameters(niter=200, burnin=100, thin=10))
}
