% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AM_mix_weights_prior.R
\name{AM_mix_weights_prior_gamma}
\alias{AM_mix_weights_prior_gamma}
\title{specify a prior on the hyperparameter \eqn{\gamma} for the Dirichlet mixture weights prior}
\usage{
AM_mix_weights_prior_gamma(a = NULL, b = NULL, gamma = NULL, init = NULL)
}
\arguments{
\item{a}{The shape parameter a of the Gamma prior.}

\item{b}{The rate parameter b of the Gamma prior.}

\item{gamma}{It allows to fix \eqn{\gamma}  to a specific value.}

\item{init}{The init value for \eqn{\gamma}, when we assume \eqn{\gamma} random.}
}
\value{
A \code{\link{AM_mix_weights_prior}} object. This is a configuration list to be used as \code{mix_weight_prior} argument for \code{\link{AM_mcmc_fit}}.
}
\description{
Generate a configuration object to specify a prior on the hyperparameter \eqn{\gamma} for the Dirichlet prior on the
mixture weights.
We assume \eqn{\gamma \sim  Gamma(a,b)}. Alternatively, we can fix \eqn{\gamma} to a specific value.
Default is \eqn{\gamma=1/N}, where N is the number of observations.
In AntMAN we assume the following
parametrization of the Gamma density:
\deqn{p(x\mid a,b )= \frac{b^a x^{a-1}}{\Gamma(a)} \exp\{ -bx \}, \quad x>0.}
}
\examples{
AM_mix_weights_prior_gamma (a=1, b=1)
AM_mix_weights_prior_gamma (a=1, b=1, init=1)
AM_mix_weights_prior_gamma (gamma = 3)
AM_mix_weights_prior_gamma () 
}
\keyword{prior}
