% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_import_IgBLAST_annotations.R
\name{VDJ_import_IgBLAST_annotations}
\alias{VDJ_import_IgBLAST_annotations}
\title{Function to import the annotations and alignments from IgBLAST output into the VDJ dataframe.}
\usage{
VDJ_import_IgBLAST_annotations(VDJ, VDJ.directory, file.path.list, method)
}
\arguments{
\item{VDJ}{dataframe - VDJ object as obtained from the VDJ_build() function in Platypus.}

\item{VDJ.directory}{string - path to parent directory containing the output folders (one folder for each sample) of Cell Ranger. This pipeline assumes that the sample IDs and contigs IDs have not been modified and that the IgBLAST output file names have not been changed from the default changeo settings. Each sample directory should contain a 'filtered_contig_igblast_db-pass.tsv' file.}

\item{file.path.list}{list - list containing the paths to the 'filtered_contig_igblast_db-pass.tsv' files, in which the names of each item should refer to an sample ID.}

\item{method}{string - denotes the way the IgBLAST germline annotations from the 'filtered_contig_igblast_db-pass.tsv' files should be appended to the VDJ dataframe. Options: 'replace' or 'attach'. Defaults to 'append'.
'replace'  : The original annotation columns in the VDJ dataframe are replaced with the IgBLAST annotations. The original columns are kept with the suffix '_10x'.
'append'   : The IgBLAST annotation columns are stored in columns with the suffix '_IgBLAST'.}
}
\value{
The VDJ dataframe with the appended IgBLAST annotations and alignments.
}
\description{
Imports the IgBLAST annotations and alignments from IgBLAST output files, stored in the output folders of Cell Ranger, into a VDJ dataframe obtained from the minimal_VDJ() function in Platypus.
}
\examples{
\dontrun{
VDJ <- VDJ_import_IgBLAST_annotations(VDJ = AntibodyForests::small_vdj,
                                      VDJ.directory = "path/to/VDJ_directory")
}
}
