% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/offspring_functions.R
\name{offspringFSfam}
\alias{offspringFSfam}
\title{Creating offspring for family design}
\usage{
offspringFSfam(
  gen,
  No,
  sire,
  dam,
  batch = 0,
  probmale = BPdata$prob_male,
  Ntraits = BPdata$Ntraits,
  TraitsIndex = c(1:Ntraits),
  Rgen = BPdata$Rgen,
  Rres = BPdata$Rres,
  Rcom = BPdata$Rcom,
  a_var = BPdata$a_var,
  c_var = BPdata$c_var,
  e_var = BPdata$e_var,
  inbreeding = TRUE
)
}
\arguments{
\item{gen}{The generation of the offspring.}

\item{No}{The number of offspring per fullsib family.}

\item{sire}{The sire of the full sib family. Sire should also be in the ped file with information on the inbreeding level and true breeding values for each trait.}

\item{dam}{The dam of the full sib family. Dam should also be in the ped file with information on the inbreeding level and the true breeding values for each trait.}

\item{batch}{The batch of the offspring. Default is 0.}

\item{probmale}{The probability that a offspring is male. The probability that the offspring is female is calculated as 1 - probmale. Probmale does not need to be specified if it is in the list called 'BPdata'. The default is 0.5.}

\item{Ntraits}{Number of traits to be simulated. Does not need to be specified if Ntraits is in the list 'BPdata'.}

\item{TraitsIndex}{Vector of traits that are in the selection index. By default, all traits are in the index.}

\item{Rgen}{Matrix of all genetic correlations between all Ntraits. Only needs to be specified if there is no matrix of genetic correlations named Rgen in the list called 'BPdata'.}

\item{Rres}{Matrix of all residual correlations between all Ntraits. Only needs to be specified if there is no matrix of residual correlations named Rres in the list called 'BPdata'.}

\item{Rcom}{Matrix of all common environmental correlations between all Ntraits. Only needs to be specified if there is no matrix of common environmental correlations named Rcom in the list called 'BPdata'.}

\item{a_var}{Vector of genetic variances of all traits. Only needs to be specified if there is no vector of genetic variances named a_var in the list called 'BPdata'.}

\item{c_var}{Vector of common environmental variances of all traits. Only needs to be specified if there is no vector of common environmental variances named c_var in the list called 'BPdata'.}

\item{e_var}{Vector of residual variances of all traits. Only needs to be specified if there is no vector of residual variances named e_var in the list called 'BPdata'.}

\item{inbreeding}{If TRUE (default), then the inbreeding level is calculated for each offspring.}
}
\value{
This function returns the 'ped' data frame: the new offspring are added to this data frame.
}
\description{
This function can be used to create the offspring of one full sib family in a family design, with genetic, common environmental and residual effects for each offspring. Offspring are added to the ped file.
}
\examples{
\donttest{ped <- founderpopfam(Nm = 60,
                     Nf = 60,
                     Nm2 = 0,
                     Nf2 = 0,
                     Ntraits = 2,
                     TraitsIndex = 2,
                     Rgen = matrix(c(1.00   , 0.48,
                                    0.48   , 1.00),
                                 nrow = 2),
                     Rcom = matrix(c(1.00  , 0.5,
                                    0.5   , 1.00),
                                 nrow = 2),
                     Rres = matrix(c(1.00   , 0.32,
                                    0.32   , 1.00),
                                 nrow = 2),
                     mean = c(50,500),
                     a_var = c(200,8000),
                     c_var = c(150,1000),
                     e_var = c(250,12000))
                     
Mating <- randommating(gen = 0,
                       Nfam_FS = 120)

for(fam in 1: nrow(Mating)){
ped <- offspringFSfam(gen = 1,
                      No = 100,
                      probmale = 0.5,
                      sire = Mating$Sire[fam],
                      dam = Mating$Dam[fam],
                      Ntraits = 2,
                      TraitsIndex = 2,
                      Rgen = matrix(c(1.00   , 0.48,
                                    0.48   , 1.00),
                                 nrow = 2),
                      Rcom = matrix(c(1.00  , 0.5,
                                    0.5   , 1.00),
                                 nrow = 2),
                      Rres = matrix(c(1.00   , 0.32,
                                    0.32   , 1.00),
                                 nrow = 2),
                      a_var = c(200,8000),
                      c_var = c(150,1000),
                      e_var = c(250,12000))
}
}
}
