% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiHPD.R
\name{MultiHPD}
\alias{MultiHPD}
\title{Bayesian HPD regions for a series of MCMC chains}
\usage{
MultiHPD(data, position, level = 0.95, roundingOfValue = 0)
}
\arguments{
\item{data}{Data frame containing the output of the MCMC algorithm.}

\item{position}{Numeric vector containing the position of the column
corresponding to the MCMC chains of interest.}

\item{level}{Probability corresponding to the level of confidence.}

\item{roundingOfValue}{Integer indicating the number of decimal places.}
}
\value{
Returns a matrix of values containing the level of confidence
and the endpoints of each interval for each variable of the MCMC chain.
The name of the resulting rows are the positions of the corresponding
columns in the CSV file. The result is given in calendar years (BC/AD).
}
\description{
Estimation of the highest posterior density regions for each variable of a
simulated Markov chain. This function uses the \code{hdr()} function
included in the \pkg{hdrcde} package. An HPD region may be a union of
several intervals.
}
\details{
Highest posterior density function region using the function
\code{hdr()} from the \pkg{hdrcd} package
}
\examples{
  data(Events)
  MultiHPD(Events, c(2, 4, 3), 0.95)

}
\references{
Hyndman, R.J. (1996) Computing and graphing highest density regions.
American Statistician, 50, 120-126.
}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr} and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
