% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_organization.R
\name{argentum_select_organization}
\alias{argentum_select_organization}
\title{Select Organization}
\usage{
argentum_select_organization(search = NULL, interactive_select = interactive())
}
\arguments{
\item{search}{An optional search term to filter organizations}

\item{interactive_select}{Logical; whether to run in interactive mode. Defaults to \code{interactive()}}
}
\value{
A data frame containing the selected organization's information, or NULL if no selection is made
}
\description{
Select Organization
}
\examples{
# List available organizations
orgs <- argentum_list_organizations()
print(orgs)

# Select organization non-interactively
selected_org <- argentum_select_organization(interactive_select = FALSE)
print(selected_org)

if(interactive()){
  # Select an organization interactively
  selected_org <- argentum_select_organization()

  # Select an organization with a search term
  selected_org <- argentum_select_organization("Example")
}
}
