% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tactical_TrendFriend_RP.R
\name{tactical_TrendFriend_RP}
\alias{tactical_TrendFriend_RP}
\title{Returns allocations for the Ivy Portfolio on a given date}
\usage{
tactical_TrendFriend_RP(strat, reb_date, P, R, risk_free = NULL)
}
\arguments{
\item{strat}{A list representing an asset allocation strategy.}

\item{reb_date}{A date on which the allocation rule is applied.}

\item{P}{An xts object with daily prices of the tickers in strat.}

\item{R}{An xts object with daily returns of the tickers in strat.}

\item{risk_free}{Either an xts object with daily returns of the risk-free}
}
\value{
A numeric vector of weights after applying the rule.
}
\description{
\code{tactical_TrendFriend_RP} determines asset allocations for a strategy
according to a modified version of the the strategy in Clare et al (2016,
<https://doi.org/10.1016/j.jbef.2016.01.002)>. The modified version uses full
risk parity instead of the inverse-volatility rule in the paper.
}
\details{
The allocation strategy proposed in the paper is based on using a a time
series momentum rule to select assets from a universe, and an allocation
rule which gives weights proportional to the inverse volatility of the assets.
The time-series (trend) momentum rule is based on whether the price of the
asset on the rebalancing date is above its 10-month moving average. If not,
the corresponding allocation in \code{strat$default_weights} is set to zero (
and is therefore allocated to the risk-free asset).
}
\examples{
trend_friend  <- asset_allocations$tactical$trend_friend
reb_date <- as.Date("2022-03-31")
tactical_TrendFriend_RP(trend_friend,
                        reb_date,
                        ETFs$Prices[, trend_friend$tickers],
                        ETFs$Returns[, trend_friend$tickers]
                        )
}
