% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitters.R
\name{sandboxMaxSplit}
\alias{sandboxMaxSplit}
\title{Bivariate score maximizing splitting}
\usage{
sandboxMaxSplit(
  bin,
  scorer,
  ties = halfCutTie,
  minExp = 5,
  pickMax = which.max,
  ...
)
}
\arguments{
\item{bin}{a bin to be split with elements `x`, `y`, `depth`,
`bnds` (list with elements `x` and `y`), `expn`, `n`}

\item{scorer}{function which accepts a numeric vector of potential
split coordinates and the bounds of `bin` and returns a numeric
vector of scores for each}

\item{ties}{function which is called to break ties when all splits
generate the same score}

\item{minExp}{value giving the smallest expected count allowed for
bin splits}

\item{pickMax}{function which accepts a list of scores and returns
the element of the largest score according to some rule}

\item{...}{optional additional arguments to `scorer`}
}
\value{
A list of two bins resulting from the split of `bin`
along the corresponding margin at the maximum location
}
\description{
A function which splits a bin based on the location
maximizing a score function.
}
\details{
This function serves as a wrapper which manages the
interaction of a score function, marginal splitting functions,
tie breaking function, and a maximum selection function to split
a bin at the observation coordinate which maximizes the score
function.
}
\author{
Chris Salahub
}
