% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docker_registry.R
\name{call_docker}
\alias{call_docker}
\title{Call the docker commandline tool}
\usage{
call_docker(cmd = "", ...)
}
\arguments{
\item{cmd}{The docker command line to execute.}

\item{...}{Other arguments to pass to \link{system2}.}
}
\value{
By default, the return code from the \code{docker} binary. The return value will have an added attribute \code{cmdline} that contains the command line. This makes it easier to construct scripts that can be run outside R.
}
\description{
Call the docker commandline tool
}
\details{
This function calls the \code{docker} binary, which must be located in your search path. AzureContainers will search for the binary at package startup, and print a warning if it is not found.
}
\examples{
\dontrun{

# without any args, prints the docker help screen
call_docker()

# build an image
call_docker("build -t myimage .")

# list running containers
call_docker("container ls")

# prune unused containers and images
call_docker("container prune -f")
call_docker("image prune -f")

}
}
\seealso{
\link{system2}, \link{call_kubectl} for the equivalent interface to the \code{kubectl} Kubernetes tool

\link{docker_registry}

\href{https://docs.docker.com/engine/reference/commandline/cli/}{Docker command line reference}
}
