% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_diagnostics.R
\name{densityplot.angmcmc}
\alias{densityplot.angmcmc}
\title{Density plots for angmcmc objects}
\usage{
\method{densityplot}{angmcmc}(x, fn = mean, log.density = FALSE,
  xpoints = seq(0, 2 * pi, length.out = 35), ypoints = seq(0, 2 * pi,
  length.out = 35), plot = TRUE, show.hist = ifelse(log.density, FALSE,
  TRUE), theta = 30, phi = 30, shade = 0.01, expand = 0.5, xlab, ylab,
  zlab = ifelse(log.density, "Log Density", "Density"), main, ...)
}
\arguments{
\item{x}{angmcmc object.}

\item{fn}{function, or a single character string specifying its name, to evaluate on MCMC samples to estimate
parameters.  Defaults to \code{mean}, which computes the estimated posterior mean.
Note that if \code{fn = "MODE"} (warning: not \code{"mode"}) or \code{fn = "MAP"}, then the maximum aposteriori estimate (MAP) is
calculated.}

\item{log.density}{logical. Should log density be used for the plot?}

\item{xpoints, ypoints}{Points on the  x and y coordinates (if bivariate) or only x coordinate
(if univariate) where the density is to be evaluated. Each defaults to seq(0, 2*pi, length.out=100).}

\item{plot}{logical. Should the density surface (if the fitted data is bivariate) or the density
curve (if univariate) be plotted?}

\item{show.hist}{logical. Should a histogram for the data
points be added to the plot, if the fitted data is univariate? Ignored if data is
bivariate.}

\item{theta, phi, shade, expand, xlab, ylab, zlab, main}{grahpical parameters passed to \link{persp} (if
bivariate) or \link{plot} (if univariate). If the data is univariate,
\code{theta, phi, shade, expand} are ignored, and \code{zlab} plays the role of
\code{ylab}.}

\item{...}{additional arguments passed to \code{\link{persp}}, if
fitted data is bivariate, or to \link{hist} (if (\code{show.hist == TRUE})), if the fitted data is univariate}
}
\description{
Plot fitted angular mixture model density surfaces or curves.
}
\details{
When \code{plot==TRUE}, \code{densityplot.angmcmc} calls \link{persp} or
\link{plot} from graphics to draw the surface or curve.

To estimate the mixture density, first the parameter vector \eqn{\eta} is estimated
by applying \code{fn} on the MCMC samples, yielding the (consistent) Bayes estimate \eqn{\hat{\eta}}. Then the mixture density
\eqn{f(x|\eta)} at any point \eqn{x} is (consistently) estimated by \eqn{f(x|\hat{\eta})}.


Note that \code{densityplot.angmcmc} \strong{does not} plot the kernel densitie estimates
of the MCMC parameters. (These plots can be obtained by first converting an \code{angmcmc}
object to an \code{mcmc} object via \link{as.mcmc.list}, and then
by using \code{densplot} from package coda on the resulting \code{mcmc.list} object. Instead,
\code{densityplot.angmcmc} returns the surface (if 2-D) or the curve (if 1-D)
of the fitted model density evaluated at the estimated parameter vector (obtain through \link{pointest}).
}
\examples{
# first fit a vmsin mixture model
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             n.chains = 1)
# now create density surface with the default first 1/3 as burn-in and thin = 1
library(lattice)
densityplot(fit.vmsin.20)
# the viewing angles can be changed through the arguments theta and phi
# (passed to persp from graphics)
densityplot(fit.vmsin.20, theta = 45, phi = 45)

# Now fit a vm mixture model
# illustration only - more iterations needed for convergence
fit.vm.20 <- fit_vmmix(wind$angle, ncomp = 3, n.iter =  20,
                             n.chains = 1)
densityplot(fit.vm.20)

}
