% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_possession.R
\name{do_possession}
\alias{do_possession}
\title{Compute when possessions start}
\usage{
do_possession(data, period_sel)
}
\arguments{
\item{data}{Play-by-play prepared data from a given game.}

\item{period_sel}{Period of interest. Options can be "xC", where x=1,2,3,4.}
}
\value{
Data frame.  This is the meaning of the columns that might not be 
explanatory by themselves:
\itemize{
  \strong{time_start}: Time point when the action starts.
  \strong{time_end}: Time point when the action ends.
  \strong{poss_time}: Duration of the possession.
  \strong{possession}: Indicates when the possession starts. This is encoded
  with the Spanish word \emph{inicio} (\emph{start}, in English).
  \strong{points}: Number of points scored from a given action.
}
}
\description{
Compute when the possession starts for each team during each period of a game.
}
\note{
1. A possession lasts 24 seconds in the ACB league.

2. Actions are given in Spanish. A bilingual basketball vocabulary (Spanish/English)
is provided in \url{https://www.uv.es/vivigui/docs/basketball_dictionary.xlsx}.

3. The \strong{game_code} column allows us to detect the source website, for example,
\url{https://live.acb.com/es/partidos/103389/jugadas}.
}
\examples{
library(dplyr)
df0 <- acb_vbc_cz_pbp_2223

day_num <- unique(acb_vbc_cz_pbp_2223$day)
game_code <- unique(acb_vbc_cz_pbp_2223$game_code)

acb_games_2223_sl <- acb_vbc_cz_sl_2223 \%>\%
  dplyr::filter(period == "1C")

df1 <- do_prepare_data(df0, day_num, 
                       acb_games_2223_sl, acb_games_2223_info,
                       game_code)
                       
df2 <- do_possession(df1, "1C")                         
#df2

}
\author{
Guillermo Vinue
}
