% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Traceplot.R
\name{traceplot}
\alias{traceplot}
\title{Trace plot function}
\usage{
traceplot(
  fit,
  cluster.indx = 1,
  feature.indx = 1,
  parameter = "PPI",
  xlab = NULL,
  ylab = NULL,
  ylim = NULL,
  xlim = NULL,
  title = NULL
)
}
\arguments{
\item{fit}{an objective output from BCC.multi() function.}

\item{cluster.indx}{a numeric value. For cluster-specific parameters,
specifying cluster.indx will generate the trace plot for
the corresponding cluster.}

\item{feature.indx}{a numeric value. For cluster-specific parameters,
specifying feature.indx will generate the trace
plot for the corresponding cluster.}

\item{parameter}{a character value. Specify which parameter for which the
trace plot will be generated. The value can be "PPI" for pi,
alpha for alpha, "GA" for gamma, "SIGMA.SQ.U" for Sigma
and "SIGMA.SQ.E" for sigma.}

\item{xlab}{Label for x axis}

\item{ylab}{Label for y axis}

\item{ylim}{The range for y axis}

\item{xlim}{The range for x axis}

\item{title}{Title for the trace plot}
}
\value{
void function with no return value, only show plots
}
\description{
To visualize the MCMC chain for model parameters
}
\examples{
# get data from the package
filePath <- system.file("extdata", "epil1.rds", package = "BCClong")
fit.BCC <- readRDS(filePath)
traceplot(fit=fit.BCC, parameter="PPI",ylab="pi",xlab="MCMC samples")

}
