% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbinomBCD.R
\name{pbinomBCD}
\alias{pbinomBCD}
\title{Cumulative Distribution Function for a Bivariate Binomial Distribution via Conditional Specification}
\usage{
pbinomBCD(x, y, n1, n2, p1, p2, lambda)
}
\arguments{
\item{x}{value at which the c.d.f. is evaluated}

\item{y}{value at which the c.d.f. is evaluated}

\item{n1}{number of trials for \eqn{ X }, must be non-negative.}

\item{n2}{number of trials for \eqn{ Y }, must be non-negative.}

\item{p1}{base success probability for \eqn{ X }, in (0, 1).}

\item{p2}{base success probability for \eqn{ Y }, in (0, 1).}

\item{lambda}{dependence parameter, must be positive.}
}
\value{
The probability \eqn{ P(X \leq x, Y \leq y) }.
}
\description{
Computes the cumulative distribution function (c.d.f.) of a bivariate binomial conditionals distribution (BBCD) as defined by Ghosh, Marques, and Chakraborty (2025).
}
\examples{
# Compute P(X \le 2, Y \le 1) with n1 = 5, n2 = 5, p1 = 0.5, p2 = 0.4, lambda = 0.5
pbinomBCD(x = 2, y = 5, n1 = 5, n2 = 5, p1 = 0.5, p2 = 0.4, lambda = 0.5)

# Example with independence (lambda = 1)
pbinomBCD(x = 1, y = 1, n1 = 10, n2 = 10, p1 = 0.3, p2 = 0.6, lambda = 1)

}
\references{
Ghosh, I., Marques, F., & Chakraborty, S. (2025). A form of bivariate binomial conditionals distributions. \emph{Communications in Statistics - Theory and Methods}m 54(2), 534--553. \doi{10.1080/03610926.2024.2315294}
}
\seealso{
\code{\link{dbinomBCD}} \code{\link{rbinomBCD}}
}
