% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_beam_boot.R
\name{plot_beam_boot}
\alias{plot_beam_boot}
\title{Plot bootstrap output for BEAM sets}
\usage{
plot_beam_boot(
  beam.result,
  beam.feat.pvals,
  beam.specs = NULL,
  set.id,
  max.plots = 4,
  z = TRUE
)
}
\arguments{
\item{beam.result}{A beam.stats object from compute_beam_stats}

\item{beam.feat.pvals}{A list containing feature-level p-values from compute_feature_pvalues.}

\item{beam.specs}{A data.frame. Default NULL, in which case beam.result$beam.specs is used. Otherwise can input other beam.specs data.frame that must contain name, mtx, mdl, plot columns.}

\item{set.id}{A character specifying the name of a set. Must be in beam.result$beam.data$set.data}

\item{max.plots}{A number specifying the max number of rows in the pairs plot. Default is 4, ordered by feature-level p-value.}

\item{z}{Logical indicating whether to z-scale each vector of one coefficient estimate across bootstraps before plotting. Default is TRUE.}
}
\value{
A pairs plot figure.
}
\description{
#' plot_beam_boot produces a pairs plot of the beam stats matrices. Default is maximum of 5 plots, ordered by most significant association direction.
}
\examples{
data(beam_stats)
test.pvals <- compute_set_pvalues(beam.stats=beam_stats)
test.feat.pvals <- compute_feature_pvalues(beam.stats=beam_stats)
test.boot.plot <- plot_beam_boot(beam_stats, test.feat.pvals,
                                 set.id="ENSG00000099810")
}
