% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convBeIds.R
\name{convBeIds}
\alias{convBeIds}
\title{Converts BE IDs}
\usage{
convBeIds(
  ids,
  from,
  from.source,
  from.org,
  to,
  to.source,
  to.org,
  caseSensitive = FALSE,
  prefFilter = FALSE,
  restricted = TRUE,
  recache = FALSE,
  limForCache = 2000
)
}
\arguments{
\item{ids}{list of identifiers}

\item{from}{a character corresponding to the biological entity or Probe.
\strong{Guessed if not provided}}

\item{from.source}{a character corresponding to the ID source.
\strong{Guessed if not provided}}

\item{from.org}{a character corresponding to the organism.
\strong{Guessed if not provided}}

\item{to}{a character corresponding to the biological entity or Probe}

\item{to.source}{a character corresponding to the ID source}

\item{to.org}{a character corresponding to the organism}

\item{caseSensitive}{if TRUE the case of provided symbols
is taken into account
during search. This option will only affect the conversion from "Symbol"
(default: caseSensitive=FALSE).
All the other conversion will be case sensitive.}

\item{prefFilter}{boolean indicating if the results should be filter
to keep only preferred BEID of BE when they exist (default: FALSE).
If there are several
preferred BEID of a BE, all are kept. If there are no preferred BEID
of a BE, all non-preferred BEID are kept.}

\item{restricted}{boolean indicating if the results should be restricted to
current version of to BEID db. If FALSE former BEID are also returned:
\strong{Depending on history it can take a very long time to return}
\strong{a very large result!}}

\item{recache}{a logical value indicating if the results should be taken from
cache or recomputed}

\item{limForCache}{if there are more ids than limForCache. Results are
collected for all IDs (beyond provided ids) and cached for futur queries.
If not, results are collected only for provided ids and not cached.}
}
\value{
a data.frame with the following columns:
\itemize{
\item \strong{from}: the input IDs
\item \strong{to}: the corresponding IDs in \code{to.source}
\item \strong{to.preferred}: boolean indicating if the to ID is a preferred
ID for the corresponding entity.
\item \strong{to.entity}: the entity technical ID of the \code{to} IDs
}

This data.frame can be filtered in order to remove duplicated
from/to.entity associations which can lead information bias.
Scope ("be", "source" and "organism") is provided as a named list
in the "scope" attributes: \code{attr(x, "scope")}
}
\description{
Converts BE IDs
}
\examples{
\dontrun{
oriId <- c("10", "100")
convBeIds(
   ids=oriId,
   from="Gene",
   from.source="EntrezGene",
   from.org="human",
   to.source="Ens_gene"
)
convBeIds(
   ids=oriId,
   from="Gene",
   from.source="EntrezGene",
   from.org="human",
   to="Peptide",
   to.source="Ens_translation"
)
convBeIds(
   ids=oriId,
   from="Gene",
   from.source="EntrezGene",
   from.org="human",
   to="Peptide",
   to.source="Ens_translation",
   to.org="mouse"
)
}

}
\seealso{
\link{getBeIdConvTable}, \link{convBeIdLists}, \link{convDfBeIds}
}
