% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findBe.R
\name{findBe}
\alias{findBe}
\title{Find Biological Entity}
\usage{
findBe(
  be = NULL,
  organism = NULL,
  ncharSymb = 4,
  ncharName = 8,
  restricted = TRUE,
  by = 20,
  exclude = c("BEDTech_gene", "BEDTech_transcript")
)
}
\arguments{
\item{be}{optional. If provided the search is focused on provided BEs.}

\item{organism}{optional.  If provided the search is focused on provided
organisms.}

\item{ncharSymb}{The minimum number of characters in searched to consider
incomplete symbol matches.}

\item{ncharName}{The minimum number of characters in searched to consider
incomplete name matches.}

\item{restricted}{boolean indicating if the results should be restricted to
current version of to BEID db. If FALSE former BEID are also returned:
\strong{Depending on history it can take a very long time to return}
\strong{a very large result!}}

\item{by}{number of found items to be converted into relevant IDs.}

\item{exclude}{database to exclude from possible selection. Used to filter
out technical database names such as "BEDTech_gene" and "BEDTech_transcript"
used to manage orphan IDs (not linked to any gene based on information
taken from sources)}
}
\value{
A data frame with the following fields:
\itemize{
\item \strong{found}: the element found in BED corresponding to the searched term
\item \strong{be}: the type of the element
\item \strong{source}: the source of the element
\item \strong{organism}: the related organism
\item \strong{entity}: the related entity internal ID
\item \strong{ebe}: the BE of the related entity
\item \strong{canonical}: if the symbol is canonical
\item \strong{Relevant ID}: the seeked element id
\item \strong{Symbol}: the symbol(s) of the corresponding gene(s)
\item \strong{Name}: the symbol(s) of the corresponding gene(s)
}

Scope ("be", "source" and "organism") is provided as a named list
in the "scope" attributes: `attr(x, "scope")``
}
\description{
Find Biological Entity in BED based on their IDs, symbols and names
}
