% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDirectOrigin.R
\name{getDirectOrigin}
\alias{getDirectOrigin}
\title{Get the direct origin of BE identifiers}
\usage{
getDirectOrigin(
  ids,
  sources = NULL,
  process = c("is_expressed_as", "is_translated_in", "codes_for")
)
}
\arguments{
\item{ids}{list of product identifiers}

\item{sources}{a character vector corresponding to the possible product ID
sources. If NULL (default), all sources are considered}

\item{process}{the production process among:
"is_expressed_as", "is_translated_in", "codes_for".}
}
\value{
a data.frame with the following columns:
\itemize{
\item \strong{origin}: the origin BE identifiers
\item \strong{osource}: the origin database
\item \strong{product}: the product BE identifiers
\item \strong{psource}: the production database
\item \strong{canonical}: whether the production process is canonical or not
}

The process is also returned as an attribute of the data.frame.
}
\description{
The origin is directly taken as provided by the original database.
This function does not return indirect relationships.
}
\examples{
\dontrun{
oriId <- c("XP_016868427", "NP_001308979")
res <- getDirectOrigin(
   ids=oriId,
   source="RefSeq_peptide",
   process="is_translated_in"
)
attr(res, "process")
}

}
\seealso{
\link{getDirectOrigin}, \link{convBeIds}
}
