% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bekk_fit_methods.R
\name{AIC.bekkFit}
\alias{AIC.bekkFit}
\alias{BIC.bekkFit}
\alias{llv}
\alias{logLik.bekkFit}
\alias{print.bekkFit}
\alias{residuals.bekkFit}
\title{bekkFit method}
\usage{
\method{AIC}{bekkFit}(object, ..., k = 2)

\method{BIC}{bekkFit}(object, ...)

llv(object)

\method{logLik}{bekkFit}(object, ..., k = 2)

\method{print}{bekkFit}(x, ...)

\method{residuals}{bekkFit}(object, ...)
}
\arguments{
\item{object}{An object of class "bekkFit" from function \link{bekk_fit}.}

\item{...}{Further arguments to be passed to and from other methods.}

\item{k}{Numeric value, the penalty per parameter for AIC to be used; the default k = 2 is the classical AIC.}

\item{x}{An object of class "bekkFit" from function \link{bekk_fit}.}
}
\description{
Generic 'bekkFit' methods. More details on 'bekkFit' are described in \link{bekk_fit}
}
\examples{
\donttest{

data(StocksBonds)

# Fitting a symmetric BEKK model
obj_spec <- bekk_spec()
x1 <- bekk_fit(obj_spec, StocksBonds, QML_t_ratios = FALSE, max_iter = 50, crit = 1e-9)

logLik(x1)
}
}
