\name{MaxBETs}
\alias{MaxBETs}
\title{Binary Expansion Testing up to a Certain Depth}
\usage{
MaxBETs(
  X,
  d.max = 4,
  unif.margin = FALSE,
  asymptotic = TRUE,
  plot = FALSE,
  index = list(c(1:ncol(X)))
)
}
\arguments{
\item{X}{a matrix to be tested. When \code{X} has only one column, \code{BETs} will test whether \code{X} is [0, 1]-uniformly distributed (an error will be given if data is out of range [0, 1]). When \code{X} has two or more columns, \code{BETs} tests the independence among those column vectors.}

\item{d.max}{the maximal depth of the binary expansion for \code{BETs}.}
\item{unif.margin}{
  logicals. If \code{TRUE} the marginal distribution is known to be Uniform[0,1]. Default is \code{FALSE}, and empirical cdf transformation will be applied to each marginal distribution.
  }
\item{asymptotic}{
  logicals. If \code{TRUE} the p-value is computed by asymptotic distribution. Default to be \code{TRUE}. Ignored if \code{X} has three or more columns.
  }
\item{plot}{
  logicals. If \code{TRUE}, make the plot of cross interaction of the strongest asymmetry. Default to be \code{FALSE}. This option only works for X with two columns.
  }
\item{index}{
  a list of indices. If provided, test the independence among two or more groups of variables, for example, \eqn{(X_1, X_2)} and \eqn{X_3}.
}
}
\value{
\item{bet.s.pvalue.bonf}{the overall p-value on the test.}
\item{bet.s.index}{the interaction that the p-value is minimal.}
\item{bet.s.zstatistic}{normal approximation of the test statistic.}
}
\description{
\code{MaxBETs} is used for nonparametric dependence detection.
Extended from \code{BET}, for a chosen maximal depth \code{d.max}, \code{MaxBETs} does a sequential test up to \code{d.max} and avoids overlapping symmetry statistics in different depths,
for all \eqn{2 \le d \le d.max}. The adjustment is done by multiplying the number of interactions which are in the \eqn{\sigma}-field generated by marginal binary expansions at depth \eqn{d} but not in that at depth \eqn{d-1}.
}
\examples{
##test mutual independence
v <- runif(128, -pi, pi)
X1 <- cos(v) + 2.5 * rnorm(128, 0, 1/20)
X2 <- sin(v) + 2.5 * rnorm(128, 0, 1/20)
MaxBETs(cbind(X1, X2), 3, asymptotic = FALSE, index = list(c(1), c(2)))

##test independence between (x1, x2) and y
x1 = runif(128)
x2 = runif(128)
y = sin(4*pi*(x1 + x2)) + 0.4*rnorm(128)
MaxBETs(cbind(x1, x2, y), 3, index = list(c(1,2), c(3)))

##test uniformity
x1 = rbeta(128, 2, 4)
x2 = rbeta(128, 2, 4)
x3 = rbeta(128, 2, 4)
MaxBETs(cbind(x1, x2, x3), 3)
}

