% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_plot.R
\name{posterior_plot}
\alias{posterior_plot}
\title{Plot Prior and Posterior Distribution}
\usage{
posterior_plot(x, prior = FALSE, plot = TRUE, ...)
}
\arguments{
\item{x}{a BFF object}

\item{prior}{whether prior distribution should
be added to the figure}

\item{plot}{whether plot should be generated.
Default to \code{TRUE}. If \code{FALSE} a data
frame with the support, prior ordinates, and
posterior ordinates is returned instead.}

\item{...}{additional arguments to the plotting
function. These include: \describe{
 \item{"x_limit"}{vector defining the plotting range,
 defaults to \code{c(-3, 3)}.}
 \item{"color"}{vector with color for the posterior and
 prior line. Defaults to \code{c("black", "grey")}}
 \item{"linetype"}{vector with linetype for the posterior and
 prior line. Defaults to \code{c(2, 1)}}
 \item{"linewidth"}{vector with linewidth for the posterior and
 prior line. Defaults to \code{c(1, 1)}}
}}
}
\value{
either a ggplot2 object if \code{plot = TRUE} or a data.frame
with prior and posterior densities if \code{plot = FALSE}
}
\description{
Creates a prior and posterior plot
of an BFF object. If no specific omega was set
when fitting the model, the omega resulting in
maximum BF against the null hypothesis is selected.
}
\seealso{
[z_test_BFF()], [t_test_BFF()], [chi2_test_BFF()], [f_test_BFF()]
}
