% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.estimate.R
\name{select.estimate}
\alias{select.estimate}
\title{Select Graphical Structure with Estimation Based Methods}
\usage{
\method{select}{estimate}(object, cred = 0.95, rope = NULL, prob = 0.95, ...)
}
\arguments{
\item{object}{object of class \code{estimate.default}}

\item{cred}{credible interval width used for the decision rule}

\item{rope}{region of practical equivalence}

\item{prob}{posterior probability (see notes)}

\item{...}{not currently used}
}
\value{
An object of class \code{select.estimate}:

\code{analytic = TRUE}:
\itemize{
\item \code{partials_non_zero} selected partial correlation matrix
\item \code{adjacency_non_zero} adjacency matrix for the selected edges
\item \code{ci} credible interval width
\item \code{analytic} TRUE
\item \code{pcors_samples} posterior samples
}

\code{analytic = FALSE}:
\itemize{
\item \code{partials_non_zero} selected partial correlation matrix
\item \code{adjacency_non_zero} adjacency matrix for the selected edges
\item \code{pcor_sd} posterior standard deviation
\item \code{ci} credible interval width
\item \code{rope} NULL

}

\code{credible interval}:
\itemize{
\item \code{partials_non_zero} selected partial correlation matrix  (outside of the rope)
\item \code{adjacency_non_zero} adjacency matrix for the selected edges (outside of the rope)
\item \code{partials_zero} partials in the rope
\item \code{adjaceny_zero} adjacency in the rope
\item \code{pcor_sd} posterior standard deviation
\item \code{call} match.call()
\item \code{rope} specified rope
\item \code{in_rope} probability in the rope
\item \code{pcors_samples} posterior samples
}
}
\description{
This allows for not only estimating the conditional dependence structure, that is non-zero edges, but also the conditional **in**dependence
structure (evidence for no relation). For the latter, the region of practical equivalence must be specified
}
\note{
The region of practical equivalence allows for assessing whether an edge is practically zero. In other words, conditional independence
(\eqn{\rho = 0}). The argument \code{prob} is then the posterior probability that must be in (practically zero edges) and out
 (practically zero edges) of the rope.
}
\examples{

# Analytic = TRUE
# p = 5
Y <- BGGM::bfi[,1:5]

# analytic solution
fit_analytic <- estimate(Y, analytic = TRUE)

# select E
E <- select(fit_analytic, ci_width = 0.95)

# non-zero partial correlations
E$partials_non_zero

# adjacency matrix
E$adjacency_non_zero
}
