% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{tas}
\alias{tas}
\title{Data: Toronto Alexithymia Scale (TAS)}
\format{
A data frame with 20 variables and 1925 observations (5 point Likert scale)
}
\usage{
data("tas")
}
\description{
A dataset containing items from the Toronto Alexithymia Scale (TAS). There are 20 variables  and
1925 observations
}
\details{
\itemize{
  \item \code{1} I am often confused about what emotion I am feeling
  \item \code{2}  It is difficult for me to find the right words for my feelings
  \item \code{3} I have physical sensations that even doctors don’t understand
  \item \code{4} I am able to describe my feelings easily
  \item \code{5} I prefer to analyze problems rather than just describe them
  \item \code{6} When I am upset, I don’t know if I am sad, frightened, or angry
  \item \code{7}  I am often puzzled by sensations in my body
  \item \code{8} I prefer just to let things happen rather than to understand why they turned out that way
  \item \code{9}  I have feelings that I can’t quite identify
  \item \code{10} Being in touch with emotions is essential
  \item \code{11}  I find it hard to describe how I feel about people
  \item \code{12} People tell me to describe my feelings more
  \item \code{13} I don’t know what’s going on inside me
  \item \code{14} I often don’t know why I am angry
  \item \code{15} I prefer talking to people about their daily activities rather than their feelings
  \item \code{16}  I prefer to watch “light” entertainment shows rather than psychological dramas
  \item \code{17} It is difficult for me to reveal my innermost feelings, even to close friends
  \item \code{18}  I can feel close to someone, even in moments of silence
  \item \code{19}  I find examination of my feelings useful in solving personal problems
  \item \code{20} Looking for hidden meanings in movies or plays distracts from their enjoyment
  \item \code{gender} "M" (male) or "F" (female)

}
}
\note{
There are three domains

Difficulty identifying feelings: items 1, 3, 6, 7, 9, 13, 14

Difficulty describing feelings: items 2, 4, 11, 12, 17

Externally oriented thinking: items 10, 15, 16, 18, 19
}
\examples{
data("tas")

# labels
tas_labels <- BGGM:::tas_labels
}
\references{
Briganti, G., & Linkowski, P. (2019). Network approach to items and domains from
the Toronto Alexithymia Scale. Psychological reports.
}
\keyword{datasets}
