% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.explore.R
\name{plot.summary.select.explore}
\alias{plot.summary.select.explore}
\title{Plot \code{summary.select.explore} Objects}
\usage{
\method{plot}{summary.select.explore}(x, size = 2, color = "black", ...)
}
\arguments{
\item{x}{An object of class \code{summary.select.explore}}

\item{size}{Numeric. The size for the points (defaults to 2).}

\item{color}{Character string. The Color for the points}

\item{...}{Currently ignored}
}
\value{
A \code{ggplot} object
}
\description{
Visualize the posterior hypothesis probabilities.
}
\examples{
\donttest{
#  data
Y <- bfi[,1:10]

# fit model
fit <- explore(Y, iter = 250,
               progress = FALSE)

# edge set
E <- select(fit,
            alternative = "exhaustive")

plot(summary(E))

}
}
