% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaPlotDiag.R
\name{GaPlotDiag}
\alias{GaPlotDiag}
\title{Diagnosis plots for Lambda, U, C and Epsilon}
\usage{
GaPlotDiag(M, variable = "Lambda", pos = 1)
}
\arguments{
\item{M}{List. Contains the output
by \code{GaMRes}.}

\item{variable}{Either "Lambda", "U", "C" or "Epsilon". Variable for which
informative plot will be shown.}

\item{pos}{Positive integer. Position of the selected \code{variable} to be
plotted.}
}
\description{
Diagnostics plots for hazard rate (Lambda), latent variable (U), dependence
parameter (C) and the parameter of the hierarchical prior (Epsilon).
}
\details{
This function returns a diagnostics plot for which the chain of the selected
variable can be monitored. Diagnostics includes trace, ergodic mean,
autocorrelation function and histogram.
}
\examples{


 
## Simulations may be time intensive. Be patient.

## Example 1
#  data(gehan)
#  timesG <- gehan$time[gehan$treat == "6-MP"]
#  deltaG <- gehan$cens[gehan$treat == "6-MP"]
#  GEX1 <- GaMRes(timesG, deltaG, K = 8, iterations = 3000)
#  GaPlotDiag(GEX1, variable = "Lambda", pos = 2)
#  GaPlotDiag(GEX1, variable = "U", pos = 5)

## Example 2
#  data(leukemiaFZ)
#  timesFZ <- leukemiaFZ$time
#  deltaFZ <- leukemiaFZ$delta
#  GEX2 <- GaMRes(timesFZ, deltaFZ, type.c = 4)
#  GaPlotDiag(GEX2, variable = "Lambda", pos = 2)
#  GaPlotDiag(GEX2, variable = "U", pos = 3)



}
\references{
- Nieto-Barajas, L. E. & Walker, S. G. (2002). Markov beta and
gamma processes for modelling hazard rates. \emph{Scandinavian Journal of
Statistics} \strong{29}: 413-424.
}
\seealso{
\link{GaMRes}
}
