% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{AIC.bgvar}
\alias{AIC.bgvar}
\title{Akaike Information Criterion}
\usage{
\method{AIC}{bgvar}(object, ..., k = 2)
}
\arguments{
\item{object}{an object of class \code{bgvar}.}

\item{...}{additional arguments.}

\item{k}{the penalty per parameter to be used. Default is set to \code{k=2}.}
}
\value{
Returns a numeric value with the corresponding AIC.
}
\description{
Computes the Akaike information criterion for an object \code{bgvar}.
}
\examples{
\dontshow{
library(BGVAR)
data(eerData)
cN<-c("EA","US","UK")
eerData<-eerData[cN]
W.trade0012<-apply(W.trade0012[cN,cN],2,function(x)x/rowSums(W.trade0012[cN,cN]))
model.ssvs <- bgvar(Data=eerData,W=W.trade0012,plag=1,saves=100,burns=100,prior="SSVS")
AIC(model.ssvs)
}
\donttest{
library(BGVAR)
data(eerData)
model.mn <- bgvar(Data=eerData,W=W.trade0012,plag=2,saves=100,burns=100,prior="MN")
AIC(model.mn)
}
}
\references{
Akaike, H. (1973) Information theory and an extension of the maximum likelihood principle. In: B. N. Petro and F. Csaki (eds.), 2nd International Symposium on Information Theory, pp. 267-281.

Akaike, H. (1974) A new look at the statistical model identification. \emph{IEEE Transactions on Automatic Control AC-19}, pp. 716-723.
}
\author{
Maximilian Boeck
}
