% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BGVAR.R
\name{logLik}
\alias{logLik}
\alias{logLik.bgvar}
\title{Extract Log-likelihood of Bayesian GVAR}
\usage{
\method{logLik}{bgvar}(object, ..., quantile = 0.5)
}
\arguments{
\item{object}{an object of class \code{bgvar}.}

\item{...}{additional arguments.}

\item{quantile}{reported quantiles. Default is set to median.}
}
\value{
Returns an vector of dimension \code{q} (number of specified quantiles) of global log-likelihoods.
}
\description{
Extract Log-Likelihood for \code{bgvar}.
}
\examples{
\donttest{
library(BGVAR)
data(eerDatasmall)
model.ng <- bgvar(Data=eerDatasmall,W=W.trade0012.small,plag=1,draws=100,burnin=100)
logLik(model.ng)
}
}
